/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client;

import dev.kir.cubeswithoutborders.client.util.FramebufferUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6364;
import net.minecraft.class_761;

@Environment(value=EnvType.CLIENT)
public final class ResizableGameRenderer {
    private static final ResizableGameRenderer INSTANCE = new ResizableGameRenderer(class_310.method_1551());
    private final class_310 client;
    private class_276 framebuffer;
    private class_276 clientFramebuffer;
    private int framebufferWidth;
    private int framebufferHeight;
    private int windowFramebufferWidth;
    private int windowFramebufferHeight;

    private ResizableGameRenderer(class_310 client) {
        this.client = client;
        this.framebuffer = null;
        this.clientFramebuffer = null;
        this.framebufferWidth = -1;
        this.framebufferHeight = -1;
    }

    public static ResizableGameRenderer getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return this.framebufferWidth > 0 && this.framebufferHeight > 0;
    }

    public boolean isRendering() {
        return this.clientFramebuffer != null;
    }

    public void resize(int width, int height) {
        this.framebufferWidth = width;
        this.framebufferHeight = height;
        this.reload();
    }

    public void reload() {
        if (!this.isEnabled()) {
            return;
        }
        FramebufferUtil.resize(this.framebuffer, this.framebufferWidth, this.framebufferHeight);
        this.resizeWorldRendererFramebuffers();
    }

    public void disable() {
        this.framebufferWidth = -1;
        this.framebufferHeight = -1;
        class_1041 window = this.client.method_22683();
        if (window != null && this.windowFramebufferWidth > 0 && this.windowFramebufferHeight > 0) {
            window.field_5181 = this.windowFramebufferWidth;
            window.field_5196 = this.windowFramebufferHeight;
        }
        this.windowFramebufferWidth = -1;
        this.windowFramebufferHeight = -1;
        if (this.clientFramebuffer != null) {
            this.client.field_1689 = this.clientFramebuffer;
            FramebufferUtil.beginWrite(this.clientFramebuffer, true);
        }
        this.clientFramebuffer = null;
        if (this.framebuffer != null) {
            this.framebuffer.method_1238();
            this.framebuffer = null;
        }
    }

    public void beginRender() {
        int width = this.framebufferWidth;
        int height = this.framebufferHeight;
        class_1041 window = this.client.method_22683();
        if (!this.isEnabled() || window == null) {
            return;
        }
        if (this.framebuffer == null) {
            this.framebuffer = new class_6364(width, height);
            this.framebuffer.method_1234(width, height);
            this.resizeWorldRendererFramebuffers();
        }
        this.windowFramebufferWidth = window.field_5181;
        this.windowFramebufferHeight = window.field_5196;
        window.field_5181 = width;
        window.field_5196 = height;
        this.clientFramebuffer = this.client.method_1522();
        this.client.field_1689 = this.framebuffer;
        FramebufferUtil.beginWrite(this.framebuffer, true);
    }

    public void endRender() {
        class_1041 window = this.client.method_22683();
        if (!this.isEnabled() || window == null) {
            return;
        }
        if (this.framebuffer == null || this.clientFramebuffer == null) {
            return;
        }
        window.field_5181 = this.windowFramebufferWidth;
        window.field_5196 = this.windowFramebufferHeight;
        this.windowFramebufferWidth = -1;
        this.windowFramebufferHeight = -1;
        this.client.field_1689 = this.clientFramebuffer;
        FramebufferUtil.beginWrite(this.clientFramebuffer, true);
        FramebufferUtil.draw(this.framebuffer, this.clientFramebuffer);
        this.clientFramebuffer = null;
    }

    private void resizeWorldRendererFramebuffers() {
        int width = this.framebufferWidth;
        int height = this.framebufferHeight;
        class_1041 window = this.client.method_22683();
        class_761 worldRenderer = this.client.field_1769;
        if (window == null) {
            return;
        }
        FramebufferUtil.resize(worldRenderer.field_53080, width, height);
    }
}

