/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3929;
import net.minecraft.class_3999;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7157;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.client.gui.integration.ContainerScreenIntegration;
import team.creative.creativecore.client.gui.integration.GuiScreenIntegration;
import team.creative.creativecore.common.config.gui.ConfigGuiLayer;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.gui.IScaleableGuiScreen;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.integration.GuiEventHandler;
import team.creative.creativecore.common.gui.style.GuiStyle;

public class CreativeCoreClient
implements ClientModInitializer {
    private static final class_310 mc = class_310.method_1551();
    private static final List<String> MOD_CONFIGS = new ArrayList<String>();

    public static Iterable<String> getModConfigs() {
        return MOD_CONFIGS;
    }

    public static void registerClientConfig(String modid) {
        MOD_CONFIGS.add(modid);
    }

    public static float getFrameTime() {
        if (mc.method_1493()) {
            return 1.0f;
        }
        return mc.method_61966().method_60637(false);
    }

    public static void commands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cmdclientconfig").executes(x -> {
            GuiEventHandler.queueScreen(new GuiScreenIntegration(new ConfigGuiLayer(true, CreativeConfigRegistry.ROOT, Side.CLIENT)));
            return 0;
        }));
    }

    public void onInitializeClient() {
        ClientTickEvents.START_CLIENT_TICK.register(GuiEventHandler::onTick);
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> GuiStyle.reload());
        class_3929.method_17542(CreativeCore.GUI_CONTAINER, (class_3929.class_3930)new class_3929.class_3930<ContainerIntegration, ContainerScreenIntegration>(this){

            public ContainerScreenIntegration create(ContainerIntegration container, class_1661 inventory, class_2561 p_create_3_) {
                return new ContainerScreenIntegration(container, inventory);
            }
        });
        ClientCommandRegistrationCallback.EVENT.register(CreativeCoreClient::commands);
        ClientTickEvents.START_CLIENT_TICK.register(CreativeCoreClient::clientTick);
    }

    public static void clientTick(class_310 client) {
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof IScaleableGuiScreen) {
            IScaleableGuiScreen scaleableGuiScreen = (IScaleableGuiScreen)class_4372;
            scaleableGuiScreen.clientTick();
        }
    }

    public static void postBackgroundEvent(class_437 screen, class_332 graphics, double mouseX, double mouseY) {
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, class_327 fallbackFont) {
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        return CreativeCoreClient.gatherTooltipComponentsFromElements(stack, elements, mouseX, screenWidth, screenHeight, fallbackFont);
    }

    public static List<class_5684> gatherTooltipComponentsFromElements(class_1799 stack, List<Either<class_5348, class_5632>> elements, int mouseX, int screenWidth, int screenHeight, class_327 fallbackFont) {
        class_327 font = fallbackFont;
        int tooltipTextWidth = elements.stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((class_327)font).method_27525(arg_0), component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        if (needsWrap) {
            return elements.stream().flatMap(either -> (Stream)either.map(text -> CreativeCoreClient.splitLine(text, font, tooltipTextWidthF), component -> Stream.of(class_5684.method_32663((class_5632)component)))).toList();
        }
        return elements.stream().map(either -> (class_5684)either.map(text -> {
            class_5481 class_54812;
            if (text instanceof class_2561) {
                class_2561 c = (class_2561)text;
                class_54812 = c.method_30937();
            } else {
                class_54812 = class_2477.method_10517().method_30934(text);
            }
            return class_5684.method_32662((class_5481)class_54812);
        }, class_5684::method_32663)).toList();
    }

    private static Stream<class_5684> splitLine(class_5348 text, class_327 font, int maxWidth) {
        class_2561 component;
        if (text instanceof class_2561 && (component = (class_2561)text).getString().isEmpty()) {
            return Stream.of(component.method_30937()).map(class_5684::method_32662);
        }
        return font.method_1728(text, maxWidth).stream().map(class_5684::method_32662);
    }

    public static Comparator<class_3999> makeParticleRenderTypeComparator(List<class_3999> renderOrder) {
        Comparator<class_3999> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((class_3999)typeOne, (class_3999)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            return vanillaOne ? -1 : 1;
        };
    }
}

