/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import javax.annotation.Nullable;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class RecipeCategoryTitle {
    private final class_5481 visibleString;
    @Nullable
    private final class_2561 tooltipString;
    private final ImmutableRect2i area;

    public static RecipeCategoryTitle create(IRecipeCategory<?> recipeCategory, class_327 font, ImmutableRect2i availableArea) {
        class_2561 tooltipString;
        class_5481 visibleString;
        class_2561 fullString = StringUtil.stripStyling(recipeCategory.getTitle());
        int availableTitleWidth = availableArea.getWidth();
        if (font.method_27525((class_5348)fullString) > availableTitleWidth) {
            class_5348 formattedText = StringUtil.truncateStringToWidth((class_5348)fullString, availableTitleWidth, font);
            visibleString = class_2477.method_10517().method_30934(formattedText);
            tooltipString = fullString;
        } else {
            visibleString = fullString.method_30937();
            tooltipString = null;
        }
        ImmutableRect2i area = MathUtil.centerTextArea(availableArea, font, visibleString);
        return new RecipeCategoryTitle(visibleString, tooltipString, area);
    }

    public RecipeCategoryTitle() {
        this(class_5481.field_26385, (class_2561)class_2561.method_43473(), ImmutableRect2i.EMPTY);
    }

    public RecipeCategoryTitle(class_5481 visibleString, @Nullable class_2561 tooltipString, ImmutableRect2i area) {
        this.visibleString = visibleString;
        this.tooltipString = tooltipString;
        this.area = area;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    public void getTooltip(JeiTooltip tooltip) {
        if (this.tooltipString != null) {
            tooltip.add((class_5348)this.tooltipString);
        }
    }

    public void draw(class_332 guiGraphics, class_327 font) {
        StringUtil.drawCenteredStringWithShadow(guiGraphics, font, this.visibleString, this.area);
    }
}

