/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.content;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import net.minecraft.class_1267;
import net.minecraft.class_1934;
import net.minecraft.class_3806;
import net.minecraft.class_3808;
import org.slf4j.Logger;

public final class ServerPropertiesHelper {
    private ServerPropertiesHelper() {
    }

    public static class_3806 createDedicatedServerProperties(Path path, final Logger logger) {
        return new class_3806(class_3808.method_16727((Path)path)){

            class_3806 setProperties() {
                String input;
                this.field_16848.put("online-mode", String.valueOf(false));
                this.field_16848.put("difficulty", class_1267.field_5807.method_15434());
                this.field_16848.put("gamemode", class_1934.field_9220.method_15434());
                this.field_16848.put("max-players", String.valueOf(4));
                this.field_16848.put("spawn-protection", String.valueOf(0));
                this.field_16848.put("view-distance", String.valueOf(16));
                Scanner scanner = new Scanner(System.in);
                Optional<String> hostAddress = ServerPropertiesHelper.getHostAddress();
                do {
                    logger.warn("Invalid server ip address! {}", (Object)(hostAddress.isPresent() ? hostAddress.map(string -> "Using fallback: " + string).get() : ""));
                    System.out.print("server-ip=");
                    input = scanner.nextLine();
                    if (!input.isBlank() || !hostAddress.isPresent()) continue;
                    input = hostAddress.get();
                } while (!input.matches("^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$"));
                this.field_16848.put("server-ip", input);
                return new class_3806(this.field_16848);
            }
        }.setProperties();
    }

    public static Optional<String> getHostAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!(address instanceof Inet4Address) || Objects.equals(address.getHostAddress(), "127.0.0.1")) continue;
                    return Optional.of(address.getHostAddress());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }
}

