/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import com.google.common.collect.Maps;
import fuzs.betteranimationscollection.client.element.SoundBasedElement;
import fuzs.betteranimationscollection.client.model.BuckaChickenModel;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import java.util.Map;
import net.minecraft.class_10009;
import net.minecraft.class_10602;
import net.minecraft.class_10756;
import net.minecraft.class_1428;
import net.minecraft.class_3417;
import net.minecraft.class_3879;
import net.minecraft.class_558;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_882;
import net.minecraft.class_922;
import net.minecraft.class_9990;
import net.neoforged.neoforge.common.ModConfigSpec;

public class BuckaChickenElement
extends SoundBasedElement<class_1428, class_10009, class_558> {
    public static boolean slimBill;
    public static boolean moveHead;
    public static boolean moveWattles;
    public static boolean moveWings;
    public static int headAnimationSpeed;
    public static int wattlesAnimationSpeed;
    public static int wingAnimationSpeed;
    private final class_5601 animatedChicken = this.registerModelLayer("animated_chicken");
    private final class_5601 animatedColdChicken = this.registerModelLayer("animated_cold_chicken");
    private final class_5601 animatedChickenBaby = this.registerModelLayer("animated_chicken_baby");
    private final class_5601 animatedColdChickenBaby = this.registerModelLayer("animated_cold_chicken_baby");

    public BuckaChickenElement() {
        super(class_1428.class, class_10009.class, class_558.class, class_3417.field_14871);
    }

    @Override
    public String[] getDescriptionComponent() {
        return new String[]{"This one makes chicken beaks open and close when they cluck.", "When they strut their heads move back and forth, the red thing under their beak swings around and their wings flap a little. Just like the real deal!"};
    }

    @Override
    protected void setAnimatedModel(class_922<?, class_10009, class_558> entityRenderer, class_5617.class_5618 context) {
        if (entityRenderer instanceof class_882) {
            class_882 chickenRenderer = (class_882)entityRenderer;
            chickenRenderer.field_56593 = this.bakeModels(context);
        } else if (entityRenderer instanceof class_9990) {
            BuckaChickenElement.setAnimatedAgeableModel(entityRenderer, new BuckaChickenModel(context.method_32167(this.animatedChicken)), new BuckaChickenModel(context.method_32167(this.animatedChickenBaby)));
        }
    }

    private Map<class_10756.class_10757, class_10602<class_558>> bakeModels(class_5617.class_5618 context) {
        return Maps.newEnumMap(Map.of(class_10756.class_10757.field_56542, new class_10602((class_3879)new BuckaChickenModel(context.method_32167(this.animatedChicken)), (class_3879)new BuckaChickenModel(context.method_32167(this.animatedChickenBaby))), class_10756.class_10757.field_56543, new class_10602((class_3879)new BuckaChickenModel(context.method_32167(this.animatedColdChicken)), (class_3879)new BuckaChickenModel(context.method_32167(this.animatedColdChickenBaby)))));
    }

    @Override
    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(this.animatedChicken, BuckaChickenModel::createAnimatedBodyLayer);
        context.registerLayerDefinition(this.animatedColdChicken, BuckaChickenModel::createAnimatedColdBodyLayer);
        context.registerLayerDefinition(this.animatedChickenBaby, () -> BuckaChickenModel.createAnimatedBodyLayer().method_62137(class_558.field_52891));
        context.registerLayerDefinition(this.animatedColdChickenBaby, () -> BuckaChickenModel.createAnimatedColdBodyLayer().method_62137(class_558.field_52891));
    }

    @Override
    public void setupModelConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        super.setupModelConfig(builder, callback);
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Make bill a lot slimmer so chickens look less like ducks.").define("slim_bill", true), v -> {
            if (slimBill != v) {
                this.markChanged();
            }
            slimBill = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Move head back and forth when chicken is walking.").define("move_head", true), v -> {
            moveHead = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Wiggle chin when chicken is walking.").define("wiggle_wattles", true), v -> {
            moveWattles = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Flap wings when chicken is walking.").define("flap_wings", true), v -> {
            moveWings = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Move head back and forth when chicken is walking.").defineInRange("head_animation_speed", 4, 1, 20), v -> {
            headAnimationSpeed = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Animation swing speed for wattles movement.").defineInRange("wattles_animation_speed", 5, 1, 20), v -> {
            wattlesAnimationSpeed = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Animation swing speed of wing flapping.").defineInRange("wing_animation_speed", 3, 1, 20), v -> {
            wingAnimationSpeed = v;
        });
    }
}

