/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.SingletonModelElement;
import fuzs.betteranimationscollection.client.model.PlayfulDoggyModel;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import net.minecraft.class_10085;
import net.minecraft.class_1493;
import net.minecraft.class_3887;
import net.minecraft.class_5601;
import net.minecraft.class_5605;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5617;
import net.minecraft.class_624;
import net.minecraft.class_9085;
import net.minecraft.class_922;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public class PlayfulDoggyElement
extends SingletonModelElement<class_1493, class_10085, class_624> {
    public static final float MAX_ROLL_ANIM = 0.47123894f;
    public static int tailLength;
    public static boolean fluffyTail;
    public static int animationSpeed;
    public static SittingAnim sittingAnim;
    private final class_5601 animatedWolf = this.registerModelLayer("animated_wolf");
    private final class_5601 animatedWolfArmor = this.registerModelLayer("animated_wolf", "armor");
    private final class_5601 animatedWolfBaby = this.registerModelLayer("animated_wolf_baby");
    private final class_5601 animatedWolfBabyArmor = this.registerModelLayer("animated_wolf_baby", "armor");

    public PlayfulDoggyElement() {
        super(class_1493.class, class_10085.class, class_624.class);
    }

    @Override
    public String[] getDescriptionComponent() {
        return new String[]{"Changes wolf tails to be fluffier and flowier, wagging realistically while they stand and run.", "Also makes tamed wolves lie down instead of sitting. Hold up some meat and they'll roll over, too."};
    }

    @Override
    protected void setAnimatedModel(class_922<?, class_10085, class_624> entityRenderer, class_5617.class_5618 context) {
        PlayfulDoggyElement.setAnimatedAgeableModel(entityRenderer, new PlayfulDoggyModel(context.method_32167(this.animatedWolf)), new PlayfulDoggyModel(context.method_32167(this.animatedWolfBaby)));
    }

    @Override
    @Nullable
    protected class_3887<class_10085, class_624> getAnimatedLayer(class_3887<class_10085, class_624> renderLayer, class_922<?, class_10085, class_624> entityRenderer, class_5617.class_5618 context) {
        if (renderLayer instanceof class_9085) {
            class_9085 wolfArmorLayer = (class_9085)renderLayer;
            wolfArmorLayer.field_53235 = new PlayfulDoggyModel(context.method_32167(this.animatedWolfArmor));
            wolfArmorLayer.field_53236 = new PlayfulDoggyModel(context.method_32167(this.animatedWolfBabyArmor));
            return wolfArmorLayer;
        }
        return super.getAnimatedLayer(renderLayer, entityRenderer, context);
    }

    @Override
    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(this.animatedWolf, () -> class_5607.method_32110((class_5609)PlayfulDoggyModel.createAnimatedBodyLayer(class_5605.field_27715), (int)64, (int)32));
        context.registerLayerDefinition(this.animatedWolfArmor, () -> class_5607.method_32110((class_5609)PlayfulDoggyModel.createAnimatedBodyLayer(new class_5605(0.2f)), (int)64, (int)32));
        context.registerLayerDefinition(this.animatedWolfBaby, () -> class_5607.method_32110((class_5609)PlayfulDoggyModel.createAnimatedBodyLayer(class_5605.field_27715), (int)64, (int)32).method_62137(class_624.field_52948));
        context.registerLayerDefinition(this.animatedWolfBabyArmor, () -> class_5607.method_32110((class_5609)PlayfulDoggyModel.createAnimatedBodyLayer(new class_5605(0.2f)), (int)64, (int)32).method_62137(class_624.field_52948));
    }

    public static float getRollAnimScale(class_10085 renderState) {
        if (renderState.field_53625 && sittingAnim.rollOver()) {
            if (sittingAnim.begForMeat()) {
                return renderState.field_53627 >= 1.0E-4f ? renderState.field_53627 / 0.47123894f : 0.0f;
            }
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public void setupModelConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Define tail length.").defineInRange("tail_length", 7, 1, 7), v -> {
            tailLength = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Make wolf tail fluffy.").define("fluffy_tail", true), v -> {
            if (fluffyTail != v) {
                this.markChanged();
            }
            fluffyTail = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Animation swing speed for tail.").defineInRange("animation_speed", 5, 1, 20), v -> {
            animationSpeed = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment(new String[]{"Pose and behaviour when sitting.", "By default makes wolves lie down instead, and roll over when a nearby player is holding a piece meat."}).defineEnum("sitting_behaviour", (Enum)SittingAnim.LIE_DOWN_AND_BEG_FOR_MEAT), v -> {
            sittingAnim = v;
        });
    }

    public static enum SittingAnim {
        VANILLA,
        LIE_DOWN,
        ROLL_OVER,
        LIE_DOWN_AND_BEG_FOR_MEAT;


        public boolean lieDown() {
            return this != VANILLA;
        }

        public boolean rollOver() {
            return this == ROLL_OVER || this == LIE_DOWN_AND_BEG_FOR_MEAT;
        }

        public boolean begForMeat() {
            return this == LIE_DOWN_AND_BEG_FOR_MEAT;
        }
    }
}

