/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import com.google.common.base.Predicates;
import fuzs.betteranimationscollection.client.element.SingletonModelElement;
import fuzs.betteranimationscollection.client.handler.RemoteSoundHandler;
import fuzs.puzzleslib.api.client.renderer.v1.RenderStateExtraData;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import fuzs.puzzleslib.api.config.v3.serialization.KeyedValueProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_10042;
import net.minecraft.class_1308;
import net.minecraft.class_169;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_583;
import net.minecraft.class_7924;
import net.neoforged.neoforge.common.ModConfigSpec;

public abstract class SoundBasedElement<T extends class_1308, S extends class_10042, M extends class_583<? super S>>
extends SingletonModelElement<T, S, M> {
    public static final class_169<Float> AMBIENT_SOUND_TIME_PROPERTY = SoundBasedElement.key("ambient_sound_time");
    private final class_3414[] sounds;

    public SoundBasedElement(Class<T> entityClazz, Class<S> renderStateClazz, Class<M> modelClazz, class_3414 ... sounds) {
        super(entityClazz, renderStateClazz, modelClazz);
        this.sounds = sounds;
        RemoteSoundHandler.INSTANCE.addAmbientSounds(entityClazz, Arrays.asList(sounds));
    }

    @Override
    protected void extractRenderState(T entity, S renderState, float partialTick) {
        super.extractRenderState(entity, renderState, partialTick);
        RenderStateExtraData.set(renderState, AMBIENT_SOUND_TIME_PROPERTY, (Object)Float.valueOf((float)(((class_1308)entity).field_6191 + entity.method_5970()) + partialTick));
    }

    @Override
    public void setupModelConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept(builder.comment(new String[]{"Mob sounds to play a unique animation for.", "Useful for adding support for modded mob variants which have different sounds from their vanilla counterparts.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern."}).defineList("mob_sounds", KeyedValueProvider.tagAppender((class_5321)class_7924.field_41225).add((Object[])this.sounds).asStringList(), () -> "", (Predicate)Predicates.alwaysTrue()), v -> {
            RemoteSoundHandler.INSTANCE.removeAmbientSounds(this.entityClazz);
            ConfigDataSet soundEvents = ConfigDataSet.from((class_5321)class_7924.field_41225, (List)v, (Class[])new Class[0]);
            RemoteSoundHandler.INSTANCE.addAmbientSounds(this.entityClazz, (Collection<class_3414>)soundEvents);
        });
    }
}

