/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.config;

import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.element.ModelElements;
import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import fuzs.puzzleslib.api.config.v3.serialization.KeyedValueProvider;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig
implements ConfigCore {
    @Config(category={"general"}, name="mobs_without_animations", description={"Mob variants that shouldn't have any model changes applied to them.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern."})
    List<String> mobBlacklistRaw = KeyedValueProvider.asString((class_5321)class_7924.field_41266, (Object[])new class_1299[0]);
    @Config(category={"general"}, description={"Block range for sound detection system to look for a mob that made a certain sound on the server, so the client may play an animation.", "The client is not sent an exact position, so the mob's location must be estimated."})
    @Config.DoubleRange(min=0.5, max=8.0)
    public double soundDetectionRange = 1.5;
    public ConfigDataSet<class_1299<?>> mobBlacklist;

    public void addToBuilder(ModConfigSpec.Builder builder, ValueCallback callback) {
        builder.push("models");
        for (Map.Entry<class_2960, ModelElement> entry : ModelElements.getModelElements().entrySet()) {
            callback.accept((ModConfigSpec.ConfigValue)builder.comment(entry.getValue().getDescriptionComponent()).define(entry.getKey().method_12832(), true), entry.getValue()::setEnabled);
        }
        builder.pop();
        for (Map.Entry<class_2960, ModelElement> entry : ModelElements.getModelElements().entrySet()) {
            builder.push(entry.getKey().method_12832());
            entry.getValue().setupModelConfig(builder, callback);
            builder.pop();
        }
    }

    public void afterConfigReload() {
        ConfigDataSet mobBlacklist = ConfigDataSet.from((class_5321)class_7924.field_41266, this.mobBlacklistRaw, (Class[])new Class[0]);
        if (!mobBlacklist.equals(this.mobBlacklist)) {
            boolean initialReload = this.mobBlacklist == null;
            this.mobBlacklist = mobBlacklist;
            if (!initialReload) {
                ModelElements.buildAnimatedModels(false);
            }
        }
    }
}

