/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import snownee.jade.Jade;
import snownee.jade.api.config.IgnoreList;
import snownee.jade.api.config.TargetOperationRepository;
import snownee.jade.impl.config.TargetOperation;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JadeCodecs;
import snownee.jade.util.JsonConfig;

public class TargetOperationRepositoryImpl<T, U>
implements TargetOperationRepository<T, U> {
    private final class_5321<? extends class_2378<T>> registry;
    private final Function<U, class_5321<T>> mapper;
    private final String fileName;
    private final Supplier<List<String>> defaultValues;
    private final Map<class_5321<T>, TargetOperation> builtIn = Maps.newIdentityHashMap();
    private final Map<class_5321<T>, TargetOperation> operations = Maps.newIdentityHashMap();

    public TargetOperationRepositoryImpl(class_5321<? extends class_2378<T>> registry, Function<U, class_5321<T>> mapper, String fileName, Supplier<List<String>> defaultValues) {
        this.registry = registry;
        this.mapper = mapper;
        this.fileName = fileName;
        this.defaultValues = defaultValues;
    }

    @Override
    public void reload(class_7225.class_7874 provider) {
        class_7225.class_7226 lookup = provider.method_46762(this.registry);
        this.operations.clear();
        this.operations.putAll(this.builtIn);
        IgnoreList list = new JsonConfig<IgnoreList>("jade/" + this.fileName, JadeCodecs.ignoreList(), null, () -> (IgnoreList)class_156.method_654((Object)new IgnoreList(), $ -> {
            $.values = this.defaultValues.get();
        })).get();
        ArrayList patterns = Lists.newArrayList();
        for (String value : list.values) {
            try {
                if (value.startsWith("/") && value.endsWith("/") && value.length() > 1) {
                    patterns.add(Pattern.compile(value.substring(1, value.length() - 1)));
                    continue;
                }
                class_5321 key = class_5321.method_29179(this.registry, (class_2960)class_2960.method_60654((String)value));
                Optional optional = lookup.method_46746(key);
                if (optional.isPresent()) {
                    this.operations.put(((class_6880.class_6883)optional.get()).method_40237(), TargetOperation.HIDE);
                    continue;
                }
                throw new IllegalArgumentException("Unknown id: " + value);
            }
            catch (Exception e) {
                Jade.LOGGER.error("Failed to parse ignore list entry: %s".formatted(value), (Throwable)e);
            }
        }
        if (!patterns.isEmpty()) {
            block3: for (class_5321 key : lookup.method_46754().toList()) {
                String s = key.method_29177().toString();
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(s).find()) continue;
                    this.operations.put(key, TargetOperation.HIDE);
                    continue block3;
                }
            }
        }
    }

    @Override
    public boolean shouldHide(class_5321<T> key) {
        return this.operations.get(key) == TargetOperation.HIDE;
    }

    @Override
    public boolean shouldPick(class_5321<T> key) {
        return this.operations.get(key) == TargetOperation.PICK;
    }

    @Override
    public void hide(class_5321<T> key) {
        this.builtIn.put(Objects.requireNonNull(key), TargetOperation.HIDE);
    }

    @Override
    public void pick(class_5321<T> key) {
        if (!CommonProxy.isPhysicallyClient()) {
            return;
        }
        this.builtIn.put(Objects.requireNonNull(key), TargetOperation.PICK);
    }

    @Override
    public class_5321<T> map(U obj) {
        return this.mapper.apply(obj);
    }
}

