/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.config;

import ca.spottedleaf.starlight.common.thread.SchedulingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int PARALLELISM;
    public static final boolean USE_STARLIGHT_FORMAT;

    public static void init() {
    }

    private static int getInt(Properties properties, Properties newProperties, String key, int def) {
        try {
            int i = Integer.parseInt(properties.getProperty(key));
            newProperties.setProperty(key, String.valueOf(i));
            return i;
        }
        catch (NumberFormatException e) {
            newProperties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    private static boolean getBoolean(Properties properties, Properties newProperties, String key, boolean def) {
        boolean boolean0 = Config.getBoolean0(properties, newProperties, key, def);
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            CustomValue incompatibilitiesValue = modContainer.getMetadata().getCustomValue("scalablelux:incompatibleConfig");
            if (incompatibilitiesValue == null || incompatibilitiesValue.getType() != CustomValue.CvType.ARRAY) continue;
            CustomValue.CvArray incompatibilities = incompatibilitiesValue.getAsArray();
            for (CustomValue value : incompatibilities) {
                String message;
                if (value.getType() != CustomValue.CvType.STRING || !value.getAsString().equals(key)) continue;
                if (Boolean.getBoolean("scalablelux.ignoreIncompatibleConfig")) {
                    message = String.format("Ignoring incompatibility of %s (defined in %s@%s)", key, modContainer.getMetadata().getId(), modContainer.getMetadata().getVersion().getFriendlyString());
                } else {
                    message = String.format("Forcing %s in scalablelux.properties to be disabled (defined in %s@%s)", key, modContainer.getMetadata().getId(), modContainer.getMetadata().getVersion().getFriendlyString());
                    boolean0 = false;
                }
                LOGGER.warn(message);
            }
        }
        return boolean0;
    }

    private static boolean getBoolean0(Properties properties, Properties newProperties, String key, boolean def) {
        try {
            boolean b = Config.parseBoolean(properties.getProperty(key));
            newProperties.setProperty(key, String.valueOf(b));
            return b;
        }
        catch (NumberFormatException e) {
            newProperties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    private static boolean parseBoolean(String string) {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (string.trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (string.trim().equalsIgnoreCase("false")) {
            return false;
        }
        throw new NumberFormatException(string);
    }

    static {
        Properties properties = new Properties();
        Properties newProperties = new Properties();
        Path path = FabricLoader.getInstance().getConfigDir().resolve("scalablelux.properties");
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, StandardOpenOption.CREATE);){
                properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!SchedulingUtil.isExternallyManaged()) {
            int parallelism = Config.getInt(properties, newProperties, "parallelism", -1);
            if (parallelism < 1) {
                parallelism = Math.max(1, Runtime.getRuntime().availableProcessors() / 3);
            }
            PARALLELISM = parallelism;
        } else {
            PARALLELISM = Math.max(1, Runtime.getRuntime().availableProcessors() / 3);
        }
        USE_STARLIGHT_FORMAT = Boolean.getBoolean("scalablelux.useStarlightFormat");
        if (USE_STARLIGHT_FORMAT) {
            LOGGER.fatal("The Starlight format is now terminally deprecated and will be removed in a future version of ScalableLux. ");
        }
        if (!newProperties.isEmpty()) {
            try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                newProperties.store(out, "Configuration file for ScalableLux");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

