/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1477;
import net.minecraft.class_1510;
import net.minecraft.class_1577;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_490;
import net.minecraft.class_5605;
import net.minecraft.class_562;
import net.minecraft.class_630;
import net.minecraft.class_8153;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.ETFConfigWarning;
import traben.entity_texture_features.config.ETFConfigWarnings;
import traben.entity_texture_features.config.screens.ETFConfigScreenWarnings;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.tconfig.gui.TConfigScreenMain;
import traben.tconfig.gui.entries.TConfigEntryCategory;

public class ETFConfigScreenMain
extends TConfigScreenMain {
    final ObjectOpenHashSet<ETFConfigWarning> warningsFound = new ObjectOpenHashSet();
    private final Random rand = new Random();
    private final LogoCreeperRenderer LOGO_CREEPER = new LogoCreeperRenderer();
    private final class_2960 BLUE = ETFUtils2.res("entity_features", "textures/gui/entity/e.png");
    private final class_2960 RED = ETFUtils2.res("entity_features", "textures/gui/entity/t.png");
    private final class_2960 YELLOW = ETFUtils2.res("entity_features", "textures/gui/entity/f.png");
    private final class_2960 LOGO_HACK = ETFUtils2.res("entity_texture_features", "textures/gui/logo.png");
    boolean shownWarning = false;
    int warningCount = 0;
    private long timer = 0L;
    private class_1309 livingEntity = null;

    public ETFConfigScreenMain(class_437 parent) {
        super("config.entity_features", parent, ETF.configHandlers, List.of(new TConfigEntryCategory("config.entity_features.textures_main"), new TConfigEntryCategory("config.entity_features.models_main").setEmptyTooltip("config.entity_features.empty_emf"), new TConfigEntryCategory("config.entity_features.sounds_main").setEmptyTooltip("config.entity_features.empty_esf"), new TConfigEntryCategory("config.entity_features.general_settings.title"), new TConfigEntryCategory("config.entity_features.optifine_settings"), new TConfigEntryCategory("config.entity_features.per_entity_settings")));
        for (ETFConfigWarning warning : ETFConfigWarnings.getRegisteredWarnings()) {
            if (!warning.isConditionMet()) continue;
            this.shownWarning = true;
            ++this.warningCount;
            this.warningsFound.add((Object)warning);
        }
    }

    public void drawEntity12106(class_332 context, int x, int y, int size, int width, int height, class_1309 entity, int mouseX, int mouseY) {
        class_490.method_2486((class_332)context, (int)x, (int)y, (int)width, (int)height, (int)size, (float)0.0625f, (float)mouseX, (float)mouseY, (class_1309)entity);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.shownWarning) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"config.entity_features.warnings_main"), button -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new ETFConfigScreenWarnings(this, this.warningsFound))).method_46434((int)((double)this.field_22789 * 0.1), (int)((double)this.field_22790 * 0.1) - 15, (int)((double)this.field_22789 * 0.2), 20).method_46431());
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.timer + 5000L < System.currentTimeMillis() && class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_73183() != null) {
            List entityList = class_310.method_1551().field_1724.method_73183().method_8335(null, class_310.method_1551().field_1724.method_5829().method_1014(128.0));
            class_1297 entity = null;
            for (int i = 0; i < Math.min(entityList.size(), 24) && !((entity = (class_1297)entityList.get(this.rand.nextInt(entityList.size()))) instanceof class_1309); ++i) {
            }
            if (entity instanceof class_1309) {
                this.livingEntity = (class_1309)entity;
                this.timer = System.currentTimeMillis();
            }
        }
        if (this.livingEntity != null && !this.livingEntity.method_31481()) {
            this.renderEntitySample(context, mouseX, mouseY);
        } else {
            int sin = (int)(Math.sin((double)System.currentTimeMillis() / 500.0) * (double)this.field_22790 * (double)0.015f);
            float yAdjust = ((float)mouseY / (float)this.field_22790 - 0.5f) * (float)this.field_22790 * 0.05f - (float)sin;
            float xAdjust = ((float)mouseX / (float)this.field_22789 - 0.5f) * (float)this.field_22789 * 0.05f - (float)sin;
            int y = (int)((float)this.field_22790 * 0.25f + yAdjust);
            int x = (int)((float)this.field_22789 * 0.15f + xAdjust);
            int square = this.field_22790 / 2 + sin * 2;
            context.method_25290(class_10799.field_56883, this.LOGO_HACK, x, y, 0.0f, 0.0f, square, square, square, square);
        }
    }

    private void renderETFLogoCreepers(class_332 context, int mouseX, int mouseY) {
        int y = (int)((double)this.field_22790 * 0.75);
        int x = (int)((double)this.field_22789 * 0.33);
        float g = (float)(-Math.atan(((float)(-mouseY) + (float)this.field_22790 / 2.0f) / 40.0f));
        float g2 = (float)(-Math.atan(((float)(-mouseX) + (float)this.field_22789 / 3.0f) / 400.0f));
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY(g2);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(-(g * 20.0f * ((float)Math.PI / 180)));
        quaternionf.mul((Quaternionfc)quaternionf2);
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22904((double)x, (double)y, 150.0);
        float scaling = (float)((double)this.field_22790 * 0.3);
        matrixStack.method_34425((Matrix4fc)new Matrix4f().scaling(scaling, scaling, -scaling));
        matrixStack.method_22907((Quaternionfc)quaternionf);
        float sin1 = (float)(Math.sin((double)System.currentTimeMillis() / 500.0) / 32.0);
        float sin2 = (float)(Math.sin((double)System.currentTimeMillis() / 500.0 + 1.0) / 32.0);
        float sin3 = (float)(Math.sin((double)System.currentTimeMillis() / 500.0 + 2.0) / 32.0);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        matrixStack.method_22903();
        matrixStack.method_22904(-0.6, (double)(-sin1), 0.0);
        matrixStack.method_22905(1.0f + sin1, 1.0f + sin1, 1.0f + sin1);
        this.LOGO_CREEPER.renderSimple(matrixStack, (class_4597)bufferSource, this.YELLOW);
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, -sin2, 0.0f);
        matrixStack.method_22905(1.0f + sin2, 1.0f + sin2, 1.0f + sin2);
        this.LOGO_CREEPER.renderSimple(matrixStack, (class_4597)bufferSource, this.RED);
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_22904(0.6, (double)(-sin3), 0.0);
        matrixStack.method_22905(1.0f + sin3, 1.0f + sin3, 1.0f + sin3);
        this.LOGO_CREEPER.renderSimple(matrixStack, (class_4597)bufferSource, this.BLUE);
        matrixStack.method_22909();
    }

    private void renderEntitySample(class_332 context, int mouseX, int mouseY) {
        double scale;
        int y = (int)((double)this.field_22790 * 0.75);
        if ((double)this.livingEntity.method_17682() < 0.7) {
            y -= (int)((double)this.field_22790 * 0.15);
        }
        int x = (int)((double)this.field_22789 * 0.33);
        float g = (float)Math.atan(((float)(-mouseY) + (float)this.field_22790 / 2.0f) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)((double)System.currentTimeMillis() / 1000.0 % (Math.PI * 2)));
        Quaternionf quaternionf2 = new Quaternionf().rotateX(-(g * 20.0f * ((float)Math.PI / 180)));
        quaternionf.mul((Quaternionfc)quaternionf2);
        double autoScale = (double)this.field_22790 * 0.4 / (double)Math.max(1.0f, Math.max(this.livingEntity.method_17682(), this.livingEntity.method_17681()));
        if (this.livingEntity instanceof class_1477) {
            y -= (int)((double)this.field_22790 * 0.15);
            scale = autoScale * 0.5;
        } else if (this.livingEntity instanceof class_1577 || this.livingEntity instanceof class_8153) {
            y -= (int)((double)this.field_22790 * 0.1);
            scale = autoScale * 0.7;
        } else if (this.livingEntity instanceof class_1510) {
            y -= (int)((double)this.field_22790 * 0.15);
            scale = autoScale * 1.5;
        } else {
            scale = autoScale;
        }
        double scaleModify = Math.sin((double)(System.currentTimeMillis() - this.timer) / 5000.0 * Math.PI) * 6.0;
        double scaleModify2 = Math.max(Math.min(Math.abs(scaleModify), 1.0), 0.0);
        int modelHeight = (int)Math.min(scale * scaleModify2, (double)this.field_22790 * 0.4);
        this.drawEntity12106(context, 0, (int)((double)this.field_22790 * 0.15), modelHeight, (int)((double)this.field_22789 * 0.6), (int)((double)this.field_22790 * 0.7), this.livingEntity, mouseX, mouseY);
    }

    public static class LogoCreeperRenderer {
        private final class_630 root = class_562.method_31991((class_5605)class_5605.field_27715).method_32109();

        public LogoCreeperRenderer() {
            this.root.method_32086((String)"right_hind_leg").field_3654 = (float)(-Math.toRadians(25.0));
            this.root.method_32086((String)"left_hind_leg").field_3654 = (float)Math.toRadians(25.0);
            this.root.method_32086((String)"left_hind_leg").field_3655 -= 2.0f;
            this.root.method_32086((String)"right_front_leg").field_3654 = (float)Math.toRadians(25.0);
            this.root.method_32086((String)"left_front_leg").field_3654 = (float)(-Math.toRadians(25.0));
            this.root.method_32086((String)"left_front_leg").field_3655 += 2.0f;
        }

        public void renderSimple(class_4587 matrix, class_4597 vcp, class_2960 texture) {
            matrix.method_22903();
            matrix.method_22905(-1.0f, -1.0f, 1.0f);
            matrix.method_46416(0.0f, -1.501f, 0.0f);
            class_1921 rendertype = class_1921.method_23572((class_2960)texture);
            if (rendertype != null) {
                class_4588 vertexconsumer = vcp.method_73477(rendertype);
                this.root.method_22698(matrix, vertexconsumer, 0xF000F0, class_4608.field_21444);
            }
            matrix.method_22909();
        }
    }
}

