/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.elementa.font.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.dediamondpro.resourcify.libs.elementa.font.data.FontInfo;
import dev.dediamondpro.resourcify.libs.universal.UGraphics;
import dev.dediamondpro.resourcify.libs.universal.utils.ReleasedDynamicTexture;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\b8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/font/data/Font;", "", "Ldev/dediamondpro/resourcify/libs/elementa/font/data/FontInfo;", "fontInfo", "Ljava/io/InputStream;", "atlas", "<init>", "(Lgg/essential/elementa/font/data/FontInfo;Ljava/io/InputStream;)V", "Ldev/dediamondpro/resourcify/libs/universal/utils/ReleasedDynamicTexture;", "getTexture", "()Ldev/dediamondpro/resourcify/libs/universal/utils/ReleasedDynamicTexture;", "Ljava/io/InputStream;", "Ldev/dediamondpro/resourcify/libs/elementa/font/data/FontInfo;", "getFontInfo", "()Lgg/essential/elementa/font/data/FontInfo;", "texture", "Ldev/dediamondpro/resourcify/libs/universal/utils/ReleasedDynamicTexture;", "Companion", "Elementa"})
public final class Font {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FontInfo fontInfo;
    @NotNull
    private final InputStream atlas;
    private ReleasedDynamicTexture texture;

    public Font(@NotNull FontInfo fontInfo, @NotNull InputStream atlas) {
        Intrinsics.checkNotNullParameter((Object)fontInfo, (String)"fontInfo");
        Intrinsics.checkNotNullParameter((Object)atlas, (String)"atlas");
        this.fontInfo = fontInfo;
        this.atlas = atlas;
    }

    @NotNull
    public final FontInfo getFontInfo() {
        return this.fontInfo;
    }

    @NotNull
    public final ReleasedDynamicTexture getTexture() {
        ReleasedDynamicTexture releasedDynamicTexture;
        if (this.texture == null) {
            ReleasedDynamicTexture releasedDynamicTexture2 = UGraphics.getTexture(this.atlas);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)releasedDynamicTexture2), (String)"getTexture(atlas)");
            this.texture = releasedDynamicTexture2;
        }
        if ((releasedDynamicTexture = this.texture) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"texture");
            releasedDynamicTexture = null;
        }
        return releasedDynamicTexture;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/font/data/Font$Companion;", "", "<init>", "()V", "", "path", "Ldev/dediamondpro/resourcify/libs/elementa/font/data/Font;", "fromResource", "(Ljava/lang/String;)Ldev/dediamondpro/resourcify/libs/elementa/font/data/Font;", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Font fromResource(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            InputStream json = this.getClass().getResourceAsStream(path + ".json");
            JsonParser jsonParser = new JsonParser();
            Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
            InputStream inputStream = json;
            Charset charset = Charsets.UTF_8;
            JsonObject jsonObject = jsonParser.parse((Reader)new InputStreamReader(inputStream, charset)).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"JsonParser().parse(json.reader()).asJsonObject");
            FontInfo fontInfo = FontInfo.Companion.fromJson(jsonObject);
            InputStream inputStream2 = this.getClass().getResourceAsStream(path + ".png");
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"this::class.java.getResourceAsStream(\"$path.png\")");
            return new Font(fontInfo, inputStream2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

