/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.gravelminer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.gravelminer.BlockBreakHandler;
import net.blay09.mods.gravelminer.GravelMinerClientSetting;
import net.blay09.mods.gravelminer.GravelMinerConfig;
import net.blay09.mods.gravelminer.network.HelloMessage;
import net.blay09.mods.gravelminer.network.ModNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class GravelMiner {
    public static final String MOD_ID = "gravelminer";
    private static final Set<UUID> hasClientSide = new HashSet<UUID>();
    private static final Map<UUID, GravelMinerClientSetting> clientSettings = new HashMap<UUID, GravelMinerClientSetting>();
    public static boolean isServerInstalled;

    public static void initialize() {
        GravelMinerConfig.initialize();
        ModNetworking.initialize(Balm.getNetworking());
        Balm.getEvents().onEvent(PlayerLoginEvent.class, event -> Balm.getNetworking().sendTo((class_1657)event.getPlayer(), (class_8710)HelloMessage.INSTANCE));
        Balm.getEvents().onEvent(BreakBlockEvent.class, BlockBreakHandler::blockBroken, EventPriority.Lowest);
    }

    public static boolean isAvailableFor(class_1657 player) {
        return !GravelMinerConfig.getActive().common.isOptIn || hasClientSide.contains(player.method_5667());
    }

    public static boolean isEnabledFor(class_1657 player) {
        return GravelMiner.isAvailableFor(player) && clientSettings.getOrDefault(player.method_5667(), GravelMinerClientSetting.DISABLED).isEnabled(player);
    }

    public static void setHasClientSide(class_1657 player) {
        hasClientSide.add(player.method_5667());
        GravelMiner.setClientSetting(player, GravelMinerClientSetting.ENABLED);
    }

    public static void setClientSetting(class_1657 player, GravelMinerClientSetting setting) {
        clientSettings.put(player.method_5667(), setting);
    }

    public static boolean isGravelBlock(class_2680 state) {
        class_2960 registryName = state != null ? class_7923.field_41175.method_10221((Object)state.method_26204()) : null;
        return registryName != null && GravelMinerConfig.getActive().common.gravelBlocks.contains(registryName);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

