/*
 * Decompiled with CFR 0.152.
 */
package fabric.io.github.adytech99.healthindicators;

import fabric.io.github.adytech99.healthindicators.config.Config;
import fabric.io.github.adytech99.healthindicators.config.ModConfig;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class RenderTracker {
    private static final class_310 client = class_310.method_1551();
    private static final ConcurrentHashMap<UUID, Integer> UUIDS = new ConcurrentHashMap();
    public static boolean after_attack = ((ModConfig)ModConfig.HANDLER.instance()).after_attack;
    private static class_1309 trackedEntity;

    public static class_1309 getTrackedEntity() {
        return trackedEntity;
    }

    public static void setTrackedEntity(class_1309 trackedEntity) {
        RenderTracker.trackedEntity = trackedEntity;
    }

    public static void tick(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (Config.getRenderingEnabled()) {
            for (class_1297 entity : client.field_1687.method_18112()) {
                class_1309 livingEntity;
                if (entity instanceof class_1309 && RenderTracker.satisfiesAdvancedCriteria(client.field_1724, livingEntity = (class_1309)entity) && RenderTracker.satisfiesList(client.field_1724, livingEntity)) {
                    RenderTracker.addToUUIDS(livingEntity);
                    continue;
                }
                RenderTracker.removeFromUUIDS(entity.method_5667());
            }
        }
        RenderTracker.trimEntities(client.field_1687);
        if (((ModConfig)ModConfig.HANDLER.instance()).after_attack != after_attack) {
            UUIDS.clear();
            after_attack = ((ModConfig)ModConfig.HANDLER.instance()).after_attack;
        }
        if (RenderTracker.getTrackedEntity() == null || RenderTracker.getTrackedEntity().method_29504() || RenderTracker.getTrackedEntity().method_31481()) {
            RenderTracker.setTrackedEntity(null);
        }
    }

    public static void onDamage(class_1282 damageSource, class_1309 livingEntity) {
        if (damageSource.method_5529() instanceof class_1657) {
            assert (RenderTracker.client.field_1687 != null);
            if (((ModConfig)ModConfig.HANDLER.instance()).after_attack && livingEntity instanceof class_1309 && RenderTracker.isEntityTypeAllowed(livingEntity, (class_1657)RenderTracker.client.field_1724) && RenderTracker.satisfiesList(RenderTracker.client.field_1724, livingEntity) && !RenderTracker.addToUUIDS(livingEntity)) {
                UUIDS.replace(livingEntity.method_5667(), ((ModConfig)ModConfig.HANDLER.instance()).time_after_hit * 20);
            }
        }
    }

    public static void trimEntities(class_638 world) {
        Iterator<Map.Entry<UUID, Integer>> iterator = UUIDS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Integer> entry2 = iterator.next();
            entry2.setValue(entry2.getValue() - 1);
            if (entry2.getValue() > 0) continue;
            iterator.remove();
        }
        UUIDS.entrySet().removeIf(entry -> RenderTracker.isInvalid(RenderTracker.getEntityFromUUID((UUID)entry.getKey(), world)) || !Config.getRenderingEnabled());
        if (UUIDS.size() >= 1536) {
            UUIDS.clear();
        }
    }

    public static void removeFromUUIDS(class_1297 entity) {
        UUIDS.remove(entity.method_5667());
    }

    public static void removeFromUUIDS(UUID uuid) {
        UUIDS.remove(uuid);
    }

    public static boolean addToUUIDS(class_1309 livingEntity) {
        if (!UUIDS.containsKey(livingEntity.method_5667())) {
            UUIDS.put(livingEntity.method_5667(), ((ModConfig)ModConfig.HANDLER.instance()).after_attack ? ((ModConfig)ModConfig.HANDLER.instance()).time_after_hit * 20 : 2400);
            return true;
        }
        return false;
    }

    public static boolean isInUUIDS(class_1309 livingEntity) {
        return UUIDS.containsKey(livingEntity.method_5667());
    }

    public static boolean overridePlayers(class_746 playerEntity, class_1309 livingEntity) {
        return ((ModConfig)ModConfig.HANDLER.instance()).override_players && livingEntity instanceof class_1657 && livingEntity != RenderTracker.client.field_1724 || livingEntity == RenderTracker.client.field_1724 && ((ModConfig)ModConfig.HANDLER.instance()).self;
    }

    public static boolean isEntityTypeAllowed(class_1309 livingEntity, class_1657 self) {
        if (!((ModConfig)ModConfig.HANDLER.instance()).passive_mobs && livingEntity instanceof class_1296) {
            return false;
        }
        if (!((ModConfig)ModConfig.HANDLER.instance()).hostile_mobs && livingEntity instanceof class_1588) {
            return false;
        }
        if (!((ModConfig)ModConfig.HANDLER.instance()).players && livingEntity instanceof class_1657) {
            return false;
        }
        return ((ModConfig)ModConfig.HANDLER.instance()).self || livingEntity != self;
    }

    public static boolean satisfiesAdvancedCriteria(class_746 player, class_1309 livingEntity) {
        if (RenderTracker.overridePlayers(player, livingEntity)) {
            return true;
        }
        if (!RenderTracker.isEntityTypeAllowed(livingEntity, (class_1657)player)) {
            return false;
        }
        if (((ModConfig)ModConfig.HANDLER.instance()).after_attack && !UUIDS.containsKey(livingEntity.method_5667())) {
            return false;
        }
        if (((ModConfig)ModConfig.HANDLER.instance()).damaged_only && (livingEntity.method_6032() == livingEntity.method_6063() || livingEntity.method_6032() > livingEntity.method_6063() * ((float)((ModConfig)ModConfig.HANDLER.instance()).max_health_percentage / 100.0f)) && livingEntity.method_6067() <= 0.0f) {
            return false;
        }
        if (((ModConfig)ModConfig.HANDLER.instance()).looking_at && !RenderTracker.isTargeted(livingEntity)) {
            return false;
        }
        if (((ModConfig)ModConfig.HANDLER.instance()).within_distance && livingEntity.method_5739((class_1297)player) > (float)((ModConfig)ModConfig.HANDLER.instance()).distance) {
            return false;
        }
        return !RenderTracker.isInvalid((class_1297)livingEntity);
    }

    public static boolean satisfiesList(class_746 player, class_1309 livingEntity) {
        if (!((ModConfig)ModConfig.HANDLER.instance()).blacklistOrWhitelist) {
            if (((ModConfig)ModConfig.HANDLER.instance()).list.isEmpty()) {
                return true;
            }
            if (((ModConfig)ModConfig.HANDLER.instance()).list.contains("minecraft:player") && livingEntity instanceof class_1657) {
                return true;
            }
        }
        String[] blacklist1 = new String[((ModConfig)ModConfig.HANDLER.instance()).list.size()];
        for (int i = 0; i < ((ModConfig)ModConfig.HANDLER.instance()).list.size(); ++i) {
            blacklist1[i] = ((ModConfig)ModConfig.HANDLER.instance()).list.get(i);
        }
        if (((ModConfig)ModConfig.HANDLER.instance()).blacklistOrWhitelist) {
            return Arrays.stream(blacklist1).noneMatch(s -> {
                if (livingEntity instanceof class_1657) {
                    return class_2561.method_30163((String)s).equals((Object)Objects.requireNonNull(livingEntity.method_5477()));
                }
                return s.equals(class_1299.method_5890((class_1299)livingEntity.method_5864()).toString());
            });
        }
        return Arrays.stream(blacklist1).anyMatch(s -> {
            if (livingEntity instanceof class_1657) {
                return class_2561.method_30163((String)s).equals((Object)Objects.requireNonNull(livingEntity.method_5477()));
            }
            return s.equals(class_1299.method_5890((class_1299)livingEntity.method_5864()).toString());
        });
    }

    public static boolean isTargeted(class_1309 livingEntity) {
        class_1297 class_12972;
        class_1297 camera = client.method_1560();
        double d = ((ModConfig)ModConfig.HANDLER.instance()).reach;
        double e = class_3532.method_33723((double)d);
        class_243 vec3d = camera.method_5836(0.0f);
        class_239 hitResult = camera.method_5745(d, 0.0f, false);
        double f = hitResult.method_17784().method_1025(vec3d);
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            e = f;
            d = Math.sqrt(e);
        }
        class_243 vec3d2 = camera.method_5828(0.0f);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * d, vec3d2.field_1351 * d, vec3d2.field_1350 * d);
        float g = 1.0f;
        class_238 box = camera.method_5829().method_18804(vec3d2.method_1021(d)).method_1009(1.0, 1.0, 1.0);
        assert (client.method_1560() != null);
        class_3966 entityHitResult = class_1675.method_18075((class_1297)client.method_1560(), (class_243)vec3d, (class_243)vec3d3, (class_238)box, entity -> !entity.method_7325() && entity.method_5863(), (double)e);
        if (entityHitResult != null && (class_12972 = entityHitResult.method_17782()) instanceof class_1309) {
            class_1309 livingEntity1 = (class_1309)class_12972;
            return livingEntity1 == livingEntity;
        }
        return false;
    }

    public static boolean isInvalid(class_1297 entity) {
        return entity == null || !entity.method_5805() || !entity.method_5709() || entity.method_33724() || !(entity instanceof class_1309) || RenderTracker.client.field_1724 == null || RenderTracker.client.field_1724.method_5854() == entity || entity.method_5756((class_1657)RenderTracker.client.field_1724);
    }

    private static class_1297 getEntityFromUUID(UUID uuid, class_638 world) {
        for (class_1297 entity : world.method_18112()) {
            if (!entity.method_5667().equals(uuid)) continue;
            return entity;
        }
        return null;
    }
}

