/*
 * Decompiled with CFR 0.152.
 */
package fabric.io.github.adytech99.healthindicators.mixin;

import fabric.io.github.adytech99.healthindicators.RenderTracker;
import fabric.io.github.adytech99.healthindicators.config.Config;
import fabric.io.github.adytech99.healthindicators.config.ModConfig;
import fabric.io.github.adytech99.healthindicators.enums.ArmorTypeEnum;
import fabric.io.github.adytech99.healthindicators.enums.HealthDisplayTypeEnum;
import fabric.io.github.adytech99.healthindicators.enums.HeartTypeEnum;
import fabric.io.github.adytech99.healthindicators.util.HeartJumpData;
import fabric.io.github.adytech99.healthindicators.util.RenderUtils;
import java.util.WeakHashMap;
import net.minecraft.class_10042;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_8646;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_922.class})
public abstract class EntityRendererMixin<T extends class_1309, S extends class_10042, M extends class_583<? super S>>
extends class_897<T, S>
implements class_3883<S, M> {
    @Unique
    private final class_310 client = class_310.method_1551();
    @Unique
    private static final class_2960 ICONS_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/gui/icons.png");
    @Unique
    private static final WeakHashMap<class_10042, class_1309> ENTITY_MAP = new WeakHashMap();

    protected EntityRendererMixin(class_5617.class_5618 ctx) {
        super(ctx);
    }

    @Inject(method={"updateRenderState(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;F)V"}, at={@At(value="TAIL")})
    public void updateRenderState(T livingEntity, S livingEntityRenderState, float f, CallbackInfo ci) {
        ENTITY_MAP.put((class_10042)livingEntityRenderState, (class_1309)livingEntity);
    }

    @Inject(method={"render(Lnet/minecraft/client/render/entity/state/LivingEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/command/OrderedRenderCommandQueue;Lnet/minecraft/client/render/state/CameraRenderState;)V"}, at={@At(value="TAIL")})
    public void render(S livingEntityRenderState, class_4587 matrixStack, class_11659 orderedRenderCommandQueue, class_12075 cameraRenderState, CallbackInfo ci) {
        class_1309 livingEntity = ENTITY_MAP.get(livingEntityRenderState);
        if (livingEntity != null && (RenderTracker.isInUUIDS(livingEntity) || Config.getOverrideAllFiltersEnabled() && !RenderTracker.isInvalid((class_1297)livingEntity))) {
            if (Config.getHeartsRenderingEnabled() || Config.getOverrideAllFiltersEnabled()) {
                if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.HEARTS) {
                    this.renderHearts(livingEntity, ((class_10042)livingEntityRenderState).field_53446, 0.0f, matrixStack, orderedRenderCommandQueue);
                } else if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.NUMBER) {
                    this.renderNumber(livingEntity, ((class_10042)livingEntityRenderState).field_53446, 0.0f, matrixStack, orderedRenderCommandQueue);
                } else if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.DYNAMIC) {
                    if (livingEntity.method_6063() > 100.0f) {
                        this.renderNumber(livingEntity, ((class_10042)livingEntityRenderState).field_53446, 0.0f, matrixStack, orderedRenderCommandQueue);
                    } else {
                        this.renderHearts(livingEntity, ((class_10042)livingEntityRenderState).field_53446, 0.0f, matrixStack, orderedRenderCommandQueue);
                    }
                }
            }
            if (Config.getArmorRenderingEnabled() || Config.getOverrideAllFiltersEnabled()) {
                this.renderArmorPoints(livingEntity, ((class_10042)livingEntityRenderState).field_53446, 0.0f, matrixStack, orderedRenderCommandQueue);
            }
        }
    }

    @Unique
    private void renderHearts(class_1309 livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_11659 orderedRenderCommandQueue) {
        double d = this.field_4676.method_23168((class_1297)livingEntity);
        class_1309 entAsT = livingEntity;
        int healthRed = class_3532.method_15386((float)livingEntity.method_6032());
        int maxHealth = class_3532.method_15386((float)livingEntity.method_6063());
        int healthYellow = class_3532.method_15386((float)livingEntity.method_6067());
        if (((ModConfig)ModConfig.HANDLER.instance()).percentage_based_health) {
            healthRed = class_3532.method_15386((float)((float)healthRed / (float)maxHealth * (float)((ModConfig)ModConfig.HANDLER.instance()).max_health));
            maxHealth = class_3532.method_15386((float)((ModConfig)ModConfig.HANDLER.instance()).max_health);
            healthYellow = class_3532.method_15386((float)livingEntity.method_6067());
        }
        int heartsRed = class_3532.method_15386((float)((float)healthRed / 2.0f));
        boolean lastRedHalf = (healthRed & 1) == 1;
        int heartsNormal = class_3532.method_15386((float)((float)maxHealth / 2.0f));
        int heartsYellow = class_3532.method_15386((float)((float)healthYellow / 2.0f));
        boolean lastYellowHalf = (healthYellow & 1) == 1;
        int heartsTotal = heartsNormal + heartsYellow;
        int heartsPerRow = ((ModConfig)ModConfig.HANDLER.instance()).icons_per_row;
        int pixelsTotal = Math.min(heartsTotal, heartsPerRow) * 8 + 1;
        float maxX = (float)pixelsTotal / 2.0f;
        float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
        double heartDensity = 50.0 - Math.max(4.0 - Math.ceil((double)heartsTotal / (double)heartsPerRow), -3.0) * 5.0;
        double h = 0.0;
        boolean isObstructed = ((ModConfig)ModConfig.HANDLER.instance()).show_through_walls;
        for (int isDrawingEmpty = 0; isDrawingEmpty < 2; ++isDrawingEmpty) {
            class_11659 targetQueue = isObstructed ? orderedRenderCommandQueue.method_73529(isDrawingEmpty) : orderedRenderCommandQueue;
            for (int heart = 0; heart < heartsTotal; ++heart) {
                if (heart % heartsPerRow == 0) {
                    h = (double)heart / heartDensity;
                }
                matrixStack.method_22903();
                matrixStack.method_22904(0.0, (double)(livingEntity.method_17682() + 0.5f) + h, 0.0);
                if (livingEntity.method_6059(class_1294.field_5924) && ((ModConfig)ModConfig.HANDLER.instance()).show_heart_effects && HeartJumpData.getWhichHeartJumping(livingEntity) == heart) {
                    matrixStack.method_22904(0.0, (double)(1.15f * scale), 0.0);
                }
                if ((this.method_3921((class_1297)entAsT, d) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof class_1657 && livingEntity != this.client.field_1724) && d <= 4096.0) {
                    matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    if (d < 100.0 && livingEntity instanceof class_1657 && livingEntity.method_73183().method_8428().method_1189(class_8646.field_45158) != null) {
                        matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    }
                }
                matrixStack.method_22907((Quaternionfc)this.field_4676.field_4686.method_23767());
                matrixStack.method_22905(-scale, scale, scale);
                matrixStack.method_22904(0.0, ((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
                float x = maxX - (float)(heart % heartsPerRow * 8);
                if (isDrawingEmpty == 0) {
                    String additionalIconEffects = "";
                    HeartTypeEnum type = HeartTypeEnum.EMPTY;
                    heartTextureId = ((ModConfig)ModConfig.HANDLER.instance()).use_vanilla_textures ? class_2960.method_60655((String)"healthindicators", (String)("textures/gui/heart/" + additionalIconEffects + type.icon + ".png")) : class_2960.method_60655((String)"minecraft", (String)("textures/gui/sprites/hud/heart/" + additionalIconEffects + type.icon + ".png"));
                    renderLayer = isObstructed ? class_1921.method_23030((class_2960)heartTextureId) : class_1921.method_23028((class_2960)heartTextureId);
                    renderType = type;
                    opacity = (float)((ModConfig)ModConfig.HANDLER.instance()).health_bar_opacity / 100.0f;
                    targetQueue.method_73483(matrixStack, renderLayer, (matricesEntry, vertexConsumer) -> {
                        Matrix4f m = matricesEntry.method_23761();
                        RenderUtils.drawHeart(m, vertexConsumer, x, renderType, livingEntity, opacity, d, isObstructed);
                    });
                } else {
                    HeartTypeEnum type;
                    if (heart < heartsRed) {
                        type = HeartTypeEnum.RED_FULL;
                        if (heart == heartsRed - 1 && lastRedHalf) {
                            type = HeartTypeEnum.RED_HALF;
                        }
                    } else if (heart < heartsNormal) {
                        type = HeartTypeEnum.EMPTY;
                    } else {
                        type = HeartTypeEnum.YELLOW_FULL;
                        if (heart == heartsTotal - 1 && lastYellowHalf) {
                            type = HeartTypeEnum.YELLOW_HALF;
                        }
                    }
                    if (type != HeartTypeEnum.EMPTY) {
                        Object additionalIconEffects = "";
                        if (type != HeartTypeEnum.YELLOW_FULL && type != HeartTypeEnum.YELLOW_HALF && type != HeartTypeEnum.EMPTY && ((ModConfig)ModConfig.HANDLER.instance()).show_heart_effects) {
                            additionalIconEffects = HeartTypeEnum.addStatusIcon(livingEntity) + HeartTypeEnum.addHardcoreIcon(livingEntity);
                        }
                        heartTextureId = ((ModConfig)ModConfig.HANDLER.instance()).use_vanilla_textures ? class_2960.method_60655((String)"healthindicators", (String)("textures/gui/heart/" + (String)additionalIconEffects + type.icon + ".png")) : class_2960.method_60655((String)"minecraft", (String)("textures/gui/sprites/hud/heart/" + (String)additionalIconEffects + type.icon + ".png"));
                        renderLayer = isObstructed ? class_1921.method_23030((class_2960)heartTextureId) : class_1921.method_23028((class_2960)heartTextureId);
                        renderType = type;
                        opacity = (float)((ModConfig)ModConfig.HANDLER.instance()).health_bar_opacity / 100.0f;
                        targetQueue.method_73483(matrixStack, renderLayer, (matricesEntry, vertexConsumer) -> {
                            Matrix4f m = matricesEntry.method_23761();
                            RenderUtils.drawHeart(m, vertexConsumer, x, renderType, livingEntity, opacity, d, isObstructed);
                        });
                    }
                }
                matrixStack.method_22909();
            }
        }
    }

    @Unique
    private void renderNumber(class_1309 livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_11659 orderedRenderCommandQueue) {
        double d = this.field_4676.method_23168((class_1297)livingEntity);
        class_1309 entAsT = livingEntity;
        String healthText = RenderUtils.getHealthText(livingEntity);
        boolean isObstructed = ((ModConfig)ModConfig.HANDLER.instance()).show_through_walls;
        matrixStack.method_22903();
        float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
        matrixStack.method_46416(0.0f, livingEntity.method_17682() + 0.5f, 0.0f);
        if ((this.method_3921((class_1297)entAsT, d) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof class_1657 && livingEntity != this.client.field_1724) && d <= 4096.0) {
            matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
            if (d < 100.0 && livingEntity instanceof class_1657 && livingEntity.method_73183().method_8428().method_1189(class_8646.field_45158) != null) {
                matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
            }
        }
        matrixStack.method_22907((Quaternionfc)this.field_4676.field_4686.method_23767());
        matrixStack.method_22905(scale, -scale, scale);
        matrixStack.method_22904(0.0, -((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
        class_327 textRenderer = class_310.method_1551().field_1772;
        float x = (float)(-textRenderer.method_1727(healthText)) / 2.0f;
        class_327.class_6415 textLayerType = isObstructed ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
        int backgroundColor = ((ModConfig)ModConfig.HANDLER.instance()).render_number_display_background_color ? ((ModConfig)ModConfig.HANDLER.instance()).number_display_background_color.getRGB() : 0;
        int textColor = ((ModConfig)ModConfig.HANDLER.instance()).number_color.getRGB();
        int opacity = ((ModConfig)ModConfig.HANDLER.instance()).health_bar_opacity;
        textColor = textColor & 0xFFFFFF | opacity * 255 / 100 << 24;
        orderedRenderCommandQueue.method_73478(matrixStack, x, 0.0f, class_2561.method_43470((String)healthText).method_30937(), ((ModConfig)ModConfig.HANDLER.instance()).render_number_display_shadow, textLayerType, 0xF000F0, textColor, backgroundColor, 0);
        matrixStack.method_22909();
    }

    @Unique
    private void renderArmorPoints(class_1309 livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_11659 orderedRenderCommandQueue) {
        double d = this.field_4676.method_23168((class_1297)livingEntity);
        class_1309 entAsT = livingEntity;
        int armor = class_3532.method_15386((float)livingEntity.method_6096());
        int maxArmor = class_3532.method_15386((float)livingEntity.method_6096());
        if (maxArmor == 0) {
            return;
        }
        int armorPoints = class_3532.method_15386((float)((float)armor / 2.0f));
        boolean lastPointHalf = (armor & 1) == 1;
        int pointsTotal = 10;
        int pointsPerRow = ((ModConfig)ModConfig.HANDLER.instance()).icons_per_row;
        int pixelsTotal = Math.min(pointsTotal, pointsPerRow) * 8 + 1;
        float maxX = (float)pixelsTotal / 2.0f;
        float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
        boolean isObstructed = ((ModConfig)ModConfig.HANDLER.instance()).show_through_walls;
        double h = 0.0;
        for (int isDrawingEmpty = 0; isDrawingEmpty < 2; ++isDrawingEmpty) {
            class_11659 targetQueue = isObstructed ? orderedRenderCommandQueue.method_73529(isDrawingEmpty + 2) : orderedRenderCommandQueue;
            for (int pointCount = 0; pointCount < pointsTotal; ++pointCount) {
                ArmorTypeEnum type;
                if (pointCount % pointsPerRow == 0) {
                    h = scale * 10.0f * (float)((pointCount / 2 + pointsPerRow - 1) / pointsPerRow);
                }
                matrixStack.method_22903();
                int extraHeight = (int)(((livingEntity.method_6063() + livingEntity.method_6067()) / 2.0f + (float)pointsPerRow - 1.0f) / (float)pointsPerRow);
                matrixStack.method_22904(0.0, (double)(livingEntity.method_17682() + 0.75f + scale * 10.0f * (float)(extraHeight - 1)) + h, 0.0);
                if ((this.method_3921((class_1297)entAsT, d) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof class_1657 && livingEntity != this.client.field_1724) && d <= 4096.0) {
                    matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    if (d < 100.0 && livingEntity instanceof class_1657 && livingEntity.method_73183().method_8428().method_1189(class_8646.field_45158) != null) {
                        matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    }
                }
                matrixStack.method_22907((Quaternionfc)this.field_4676.field_4686.method_23767());
                matrixStack.method_22905(-scale, scale, scale);
                matrixStack.method_22904(0.0, ((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
                float x = maxX - (float)(pointCount % pointsPerRow * 8);
                ArmorTypeEnum armorTypeEnum = isDrawingEmpty == 0 ? ArmorTypeEnum.EMPTY : (pointCount < armorPoints ? (pointCount == armorPoints - 1 && lastPointHalf ? ArmorTypeEnum.HALF : ArmorTypeEnum.FULL) : (type = null));
                if (type != null) {
                    class_2960 armorTextureId = type.icon;
                    class_1921 renderLayer = isObstructed ? class_1921.method_23030((class_2960)armorTextureId) : class_1921.method_23028((class_2960)armorTextureId);
                    ArmorTypeEnum renderType = type;
                    float opacity = (float)((ModConfig)ModConfig.HANDLER.instance()).health_bar_opacity / 100.0f;
                    targetQueue.method_73483(matrixStack, renderLayer, (matricesEntry, vertexConsumer) -> {
                        Matrix4f m = matricesEntry.method_23761();
                        RenderUtils.drawArmor(m, vertexConsumer, x, renderType, opacity, d, isObstructed);
                    });
                }
                matrixStack.method_22909();
            }
        }
    }
}

