/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import neoforge.io.github.adytech99.healthindicators.config.Config;
import neoforge.io.github.adytech99.healthindicators.config.ModConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RenderTracker {
    private static final Minecraft client = Minecraft.getInstance();
    private static final ConcurrentHashMap<UUID, Integer> UUIDS = new ConcurrentHashMap();
    public static boolean after_attack = ((ModConfig)ModConfig.HANDLER.instance()).after_attack;
    private static LivingEntity trackedEntity;

    public static LivingEntity getTrackedEntity() {
        return trackedEntity;
    }

    public static void setTrackedEntity(LivingEntity trackedEntity) {
        RenderTracker.trackedEntity = trackedEntity;
    }

    public static void tick(Minecraft client) {
        if (client.player == null || client.level == null) {
            return;
        }
        if (Config.getRenderingEnabled()) {
            for (Entity entity : client.level.entitiesForRendering()) {
                LivingEntity livingEntity;
                if (entity instanceof LivingEntity && RenderTracker.satisfiesAdvancedCriteria(client.player, livingEntity = (LivingEntity)entity) && RenderTracker.satisfiesList(client.player, livingEntity)) {
                    RenderTracker.addToUUIDS(livingEntity);
                    continue;
                }
                RenderTracker.removeFromUUIDS(entity.getUUID());
            }
        }
        RenderTracker.trimEntities(client.level);
        if (((ModConfig)ModConfig.HANDLER.instance()).after_attack != after_attack) {
            UUIDS.clear();
            after_attack = ((ModConfig)ModConfig.HANDLER.instance()).after_attack;
        }
        if (RenderTracker.getTrackedEntity() == null || RenderTracker.getTrackedEntity().isDeadOrDying() || RenderTracker.getTrackedEntity().isRemoved()) {
            RenderTracker.setTrackedEntity(null);
        }
    }

    public static void onDamage(DamageSource damageSource, LivingEntity livingEntity) {
        if (damageSource.getEntity() instanceof Player) {
            assert (RenderTracker.client.level != null);
            if (((ModConfig)ModConfig.HANDLER.instance()).after_attack && livingEntity instanceof LivingEntity && RenderTracker.isEntityTypeAllowed(livingEntity, (Player)RenderTracker.client.player) && RenderTracker.satisfiesList(RenderTracker.client.player, livingEntity) && !RenderTracker.addToUUIDS(livingEntity)) {
                UUIDS.replace(livingEntity.getUUID(), ((ModConfig)ModConfig.HANDLER.instance()).time_after_hit * 20);
            }
        }
    }

    public static void trimEntities(ClientLevel world) {
        Iterator<Map.Entry<UUID, Integer>> iterator = UUIDS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Integer> entry2 = iterator.next();
            entry2.setValue(entry2.getValue() - 1);
            if (entry2.getValue() > 0) continue;
            iterator.remove();
        }
        UUIDS.entrySet().removeIf(entry -> RenderTracker.isInvalid(RenderTracker.getEntityFromUUID((UUID)entry.getKey(), world)) || !Config.getRenderingEnabled());
        if (UUIDS.size() >= 1536) {
            UUIDS.clear();
        }
    }

    public static void removeFromUUIDS(Entity entity) {
        UUIDS.remove(entity.getUUID());
    }

    public static void removeFromUUIDS(UUID uuid) {
        UUIDS.remove(uuid);
    }

    public static boolean addToUUIDS(LivingEntity livingEntity) {
        if (!UUIDS.containsKey(livingEntity.getUUID())) {
            UUIDS.put(livingEntity.getUUID(), ((ModConfig)ModConfig.HANDLER.instance()).after_attack ? ((ModConfig)ModConfig.HANDLER.instance()).time_after_hit * 20 : 2400);
            return true;
        }
        return false;
    }

    public static boolean isInUUIDS(LivingEntity livingEntity) {
        return UUIDS.containsKey(livingEntity.getUUID());
    }

    public static boolean overridePlayers(LocalPlayer playerEntity, LivingEntity livingEntity) {
        return ((ModConfig)ModConfig.HANDLER.instance()).override_players && livingEntity instanceof Player && livingEntity != RenderTracker.client.player || livingEntity == RenderTracker.client.player && ((ModConfig)ModConfig.HANDLER.instance()).self;
    }

    public static boolean isEntityTypeAllowed(LivingEntity livingEntity, Player self) {
        if (!((ModConfig)ModConfig.HANDLER.instance()).passive_mobs && livingEntity instanceof AgeableMob) {
            return false;
        }
        if (!((ModConfig)ModConfig.HANDLER.instance()).hostile_mobs && livingEntity instanceof Monster) {
            return false;
        }
        if (!((ModConfig)ModConfig.HANDLER.instance()).players && livingEntity instanceof Player) {
            return false;
        }
        return ((ModConfig)ModConfig.HANDLER.instance()).self || livingEntity != self;
    }

    public static boolean satisfiesAdvancedCriteria(LocalPlayer player, LivingEntity livingEntity) {
        if (RenderTracker.overridePlayers(player, livingEntity)) {
            return true;
        }
        if (!RenderTracker.isEntityTypeAllowed(livingEntity, (Player)player)) {
            return false;
        }
        if (((ModConfig)ModConfig.HANDLER.instance()).after_attack && !UUIDS.containsKey(livingEntity.getUUID())) {
            return false;
        }
        if (((ModConfig)ModConfig.HANDLER.instance()).damaged_only && (livingEntity.getHealth() == livingEntity.getMaxHealth() || livingEntity.getHealth() > livingEntity.getMaxHealth() * ((float)((ModConfig)ModConfig.HANDLER.instance()).max_health_percentage / 100.0f)) && livingEntity.getAbsorptionAmount() <= 0.0f) {
            return false;
        }
        if (((ModConfig)ModConfig.HANDLER.instance()).looking_at && !RenderTracker.isTargeted(livingEntity)) {
            return false;
        }
        if (((ModConfig)ModConfig.HANDLER.instance()).within_distance && livingEntity.distanceTo((Entity)player) > (float)((ModConfig)ModConfig.HANDLER.instance()).distance) {
            return false;
        }
        return !RenderTracker.isInvalid((Entity)livingEntity);
    }

    public static boolean satisfiesList(LocalPlayer player, LivingEntity livingEntity) {
        if (!((ModConfig)ModConfig.HANDLER.instance()).blacklistOrWhitelist) {
            if (((ModConfig)ModConfig.HANDLER.instance()).list.isEmpty()) {
                return true;
            }
            if (((ModConfig)ModConfig.HANDLER.instance()).list.contains("minecraft:player") && livingEntity instanceof Player) {
                return true;
            }
        }
        String[] blacklist1 = new String[((ModConfig)ModConfig.HANDLER.instance()).list.size()];
        for (int i = 0; i < ((ModConfig)ModConfig.HANDLER.instance()).list.size(); ++i) {
            blacklist1[i] = ((ModConfig)ModConfig.HANDLER.instance()).list.get(i);
        }
        if (((ModConfig)ModConfig.HANDLER.instance()).blacklistOrWhitelist) {
            return Arrays.stream(blacklist1).noneMatch(s -> {
                if (livingEntity instanceof Player) {
                    return Component.nullToEmpty((String)s).equals((Object)Objects.requireNonNull(livingEntity.getName()));
                }
                return s.equals(EntityType.getKey((EntityType)livingEntity.getType()).toString());
            });
        }
        return Arrays.stream(blacklist1).anyMatch(s -> {
            if (livingEntity instanceof Player) {
                return Component.nullToEmpty((String)s).equals((Object)Objects.requireNonNull(livingEntity.getName()));
            }
            return s.equals(EntityType.getKey((EntityType)livingEntity.getType()).toString());
        });
    }

    public static boolean isTargeted(LivingEntity livingEntity) {
        Entity entity2;
        Entity camera = client.getCameraEntity();
        double d = ((ModConfig)ModConfig.HANDLER.instance()).reach;
        double e = Mth.square((double)d);
        Vec3 vec3d = camera.getEyePosition(0.0f);
        HitResult hitResult = camera.pick(d, 0.0f, false);
        double f = hitResult.getLocation().distanceToSqr(vec3d);
        if (hitResult.getType() != HitResult.Type.MISS) {
            e = f;
            d = Math.sqrt(e);
        }
        Vec3 vec3d2 = camera.getViewVector(0.0f);
        Vec3 vec3d3 = vec3d.add(vec3d2.x * d, vec3d2.y * d, vec3d2.z * d);
        float g = 1.0f;
        AABB box = camera.getBoundingBox().expandTowards(vec3d2.scale(d)).inflate(1.0, 1.0, 1.0);
        assert (client.getCameraEntity() != null);
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)client.getCameraEntity(), (Vec3)vec3d, (Vec3)vec3d3, (AABB)box, entity -> !entity.isSpectator() && entity.isPickable(), (double)e);
        if (entityHitResult != null && (entity2 = entityHitResult.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity1 = (LivingEntity)entity2;
            return livingEntity1 == livingEntity;
        }
        return false;
    }

    public static boolean isInvalid(Entity entity) {
        return entity == null || !entity.isAlive() || !entity.showVehicleHealth() || entity.touchingUnloadedChunk() || !(entity instanceof LivingEntity) || RenderTracker.client.player == null || RenderTracker.client.player.getVehicle() == entity || entity.isInvisibleTo((Player)RenderTracker.client.player);
    }

    private static Entity getEntityFromUUID(UUID uuid, ClientLevel world) {
        for (Entity entity : world.entitiesForRendering()) {
            if (!entity.getUUID().equals(uuid)) continue;
            return entity;
        }
        return null;
    }
}

