/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.WeakHashMap;
import neoforge.io.github.adytech99.healthindicators.RenderTracker;
import neoforge.io.github.adytech99.healthindicators.config.Config;
import neoforge.io.github.adytech99.healthindicators.config.ModConfig;
import neoforge.io.github.adytech99.healthindicators.enums.ArmorTypeEnum;
import neoforge.io.github.adytech99.healthindicators.enums.HealthDisplayTypeEnum;
import neoforge.io.github.adytech99.healthindicators.enums.HeartTypeEnum;
import neoforge.io.github.adytech99.healthindicators.util.HeartJumpData;
import neoforge.io.github.adytech99.healthindicators.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.DisplaySlot;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class EntityRendererMixin<T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>>
extends EntityRenderer<T, S>
implements RenderLayerParent<S, M> {
    @Unique
    private final Minecraft client = Minecraft.getInstance();
    @Unique
    private static final ResourceLocation ICONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/icons.png");
    @Unique
    private static final WeakHashMap<LivingEntityRenderState, LivingEntity> ENTITY_MAP = new WeakHashMap();

    protected EntityRendererMixin(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;F)V"}, at={@At(value="TAIL")})
    public void updateRenderState(T livingEntity, S livingEntityRenderState, float f, CallbackInfo ci) {
        ENTITY_MAP.put((LivingEntityRenderState)livingEntityRenderState, (LivingEntity)livingEntity);
    }

    @Inject(method={"submit(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="TAIL")})
    public void render(S livingEntityRenderState, PoseStack matrixStack, SubmitNodeCollector orderedRenderCommandQueue, CameraRenderState cameraRenderState, CallbackInfo ci) {
        LivingEntity livingEntity = ENTITY_MAP.get(livingEntityRenderState);
        if (livingEntity != null && (RenderTracker.isInUUIDS(livingEntity) || Config.getOverrideAllFiltersEnabled() && !RenderTracker.isInvalid((Entity)livingEntity))) {
            if (Config.getHeartsRenderingEnabled() || Config.getOverrideAllFiltersEnabled()) {
                if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.HEARTS) {
                    this.renderHearts(livingEntity, ((LivingEntityRenderState)livingEntityRenderState).bodyRot, 0.0f, matrixStack, orderedRenderCommandQueue);
                } else if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.NUMBER) {
                    this.renderNumber(livingEntity, ((LivingEntityRenderState)livingEntityRenderState).bodyRot, 0.0f, matrixStack, orderedRenderCommandQueue);
                } else if (((ModConfig)ModConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.DYNAMIC) {
                    if (livingEntity.getMaxHealth() > 100.0f) {
                        this.renderNumber(livingEntity, ((LivingEntityRenderState)livingEntityRenderState).bodyRot, 0.0f, matrixStack, orderedRenderCommandQueue);
                    } else {
                        this.renderHearts(livingEntity, ((LivingEntityRenderState)livingEntityRenderState).bodyRot, 0.0f, matrixStack, orderedRenderCommandQueue);
                    }
                }
            }
            if (Config.getArmorRenderingEnabled() || Config.getOverrideAllFiltersEnabled()) {
                this.renderArmorPoints(livingEntity, ((LivingEntityRenderState)livingEntityRenderState).bodyRot, 0.0f, matrixStack, orderedRenderCommandQueue);
            }
        }
    }

    @Unique
    private void renderHearts(LivingEntity livingEntity, float yaw, float tickDelta, PoseStack matrixStack, SubmitNodeCollector orderedRenderCommandQueue) {
        double d = this.entityRenderDispatcher.distanceToSqr((Entity)livingEntity);
        LivingEntity entAsT = livingEntity;
        int healthRed = Mth.ceil((float)livingEntity.getHealth());
        int maxHealth = Mth.ceil((float)livingEntity.getMaxHealth());
        int healthYellow = Mth.ceil((float)livingEntity.getAbsorptionAmount());
        if (((ModConfig)ModConfig.HANDLER.instance()).percentage_based_health) {
            healthRed = Mth.ceil((float)((float)healthRed / (float)maxHealth * (float)((ModConfig)ModConfig.HANDLER.instance()).max_health));
            maxHealth = Mth.ceil((float)((ModConfig)ModConfig.HANDLER.instance()).max_health);
            healthYellow = Mth.ceil((float)livingEntity.getAbsorptionAmount());
        }
        int heartsRed = Mth.ceil((float)((float)healthRed / 2.0f));
        boolean lastRedHalf = (healthRed & 1) == 1;
        int heartsNormal = Mth.ceil((float)((float)maxHealth / 2.0f));
        int heartsYellow = Mth.ceil((float)((float)healthYellow / 2.0f));
        boolean lastYellowHalf = (healthYellow & 1) == 1;
        int heartsTotal = heartsNormal + heartsYellow;
        int heartsPerRow = ((ModConfig)ModConfig.HANDLER.instance()).icons_per_row;
        int pixelsTotal = Math.min(heartsTotal, heartsPerRow) * 8 + 1;
        float maxX = (float)pixelsTotal / 2.0f;
        float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
        double heartDensity = 50.0 - Math.max(4.0 - Math.ceil((double)heartsTotal / (double)heartsPerRow), -3.0) * 5.0;
        double h = 0.0;
        boolean isObstructed = ((ModConfig)ModConfig.HANDLER.instance()).show_through_walls;
        for (int isDrawingEmpty = 0; isDrawingEmpty < 2; ++isDrawingEmpty) {
            SubmitNodeCollector targetQueue = isObstructed ? orderedRenderCommandQueue.order(isDrawingEmpty) : orderedRenderCommandQueue;
            for (int heart = 0; heart < heartsTotal; ++heart) {
                if (heart % heartsPerRow == 0) {
                    h = (double)heart / heartDensity;
                }
                matrixStack.pushPose();
                matrixStack.translate(0.0, (double)(livingEntity.getBbHeight() + 0.5f) + h, 0.0);
                if (livingEntity.hasEffect(MobEffects.REGENERATION) && ((ModConfig)ModConfig.HANDLER.instance()).show_heart_effects && HeartJumpData.getWhichHeartJumping(livingEntity) == heart) {
                    matrixStack.translate(0.0, (double)(1.15f * scale), 0.0);
                }
                if ((this.shouldShowName((Entity)entAsT, d) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof Player && livingEntity != this.client.player) && d <= 4096.0) {
                    matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
                    if (d < 100.0 && livingEntity instanceof Player && livingEntity.level().getScoreboard().getDisplayObjective(DisplaySlot.BELOW_NAME) != null) {
                        matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
                    }
                }
                matrixStack.mulPose((Quaternionfc)this.entityRenderDispatcher.camera.rotation());
                matrixStack.scale(-scale, scale, scale);
                matrixStack.translate(0.0, ((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
                float x = maxX - (float)(heart % heartsPerRow * 8);
                if (isDrawingEmpty == 0) {
                    String additionalIconEffects = "";
                    HeartTypeEnum type = HeartTypeEnum.EMPTY;
                    heartTextureId = ((ModConfig)ModConfig.HANDLER.instance()).use_vanilla_textures ? ResourceLocation.fromNamespaceAndPath((String)"healthindicators", (String)("textures/gui/heart/" + additionalIconEffects + type.icon + ".png")) : ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("textures/gui/sprites/hud/heart/" + additionalIconEffects + type.icon + ".png"));
                    renderLayer = isObstructed ? RenderType.textSeeThrough((ResourceLocation)heartTextureId) : RenderType.text((ResourceLocation)heartTextureId);
                    renderType = type;
                    opacity = (float)((ModConfig)ModConfig.HANDLER.instance()).health_bar_opacity / 100.0f;
                    targetQueue.submitCustomGeometry(matrixStack, renderLayer, (matricesEntry, vertexConsumer) -> {
                        Matrix4f m = matricesEntry.pose();
                        RenderUtils.drawHeart(m, vertexConsumer, x, renderType, livingEntity, opacity, d, isObstructed);
                    });
                } else {
                    HeartTypeEnum type;
                    if (heart < heartsRed) {
                        type = HeartTypeEnum.RED_FULL;
                        if (heart == heartsRed - 1 && lastRedHalf) {
                            type = HeartTypeEnum.RED_HALF;
                        }
                    } else if (heart < heartsNormal) {
                        type = HeartTypeEnum.EMPTY;
                    } else {
                        type = HeartTypeEnum.YELLOW_FULL;
                        if (heart == heartsTotal - 1 && lastYellowHalf) {
                            type = HeartTypeEnum.YELLOW_HALF;
                        }
                    }
                    if (type != HeartTypeEnum.EMPTY) {
                        Object additionalIconEffects = "";
                        if (type != HeartTypeEnum.YELLOW_FULL && type != HeartTypeEnum.YELLOW_HALF && type != HeartTypeEnum.EMPTY && ((ModConfig)ModConfig.HANDLER.instance()).show_heart_effects) {
                            additionalIconEffects = HeartTypeEnum.addStatusIcon(livingEntity) + HeartTypeEnum.addHardcoreIcon(livingEntity);
                        }
                        heartTextureId = ((ModConfig)ModConfig.HANDLER.instance()).use_vanilla_textures ? ResourceLocation.fromNamespaceAndPath((String)"healthindicators", (String)("textures/gui/heart/" + (String)additionalIconEffects + type.icon + ".png")) : ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("textures/gui/sprites/hud/heart/" + (String)additionalIconEffects + type.icon + ".png"));
                        renderLayer = isObstructed ? RenderType.textSeeThrough((ResourceLocation)heartTextureId) : RenderType.text((ResourceLocation)heartTextureId);
                        renderType = type;
                        opacity = (float)((ModConfig)ModConfig.HANDLER.instance()).health_bar_opacity / 100.0f;
                        targetQueue.submitCustomGeometry(matrixStack, renderLayer, (matricesEntry, vertexConsumer) -> {
                            Matrix4f m = matricesEntry.pose();
                            RenderUtils.drawHeart(m, vertexConsumer, x, renderType, livingEntity, opacity, d, isObstructed);
                        });
                    }
                }
                matrixStack.popPose();
            }
        }
    }

    @Unique
    private void renderNumber(LivingEntity livingEntity, float yaw, float tickDelta, PoseStack matrixStack, SubmitNodeCollector orderedRenderCommandQueue) {
        double d = this.entityRenderDispatcher.distanceToSqr((Entity)livingEntity);
        LivingEntity entAsT = livingEntity;
        String healthText = RenderUtils.getHealthText(livingEntity);
        boolean isObstructed = ((ModConfig)ModConfig.HANDLER.instance()).show_through_walls;
        matrixStack.pushPose();
        float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
        matrixStack.translate(0.0f, livingEntity.getBbHeight() + 0.5f, 0.0f);
        if ((this.shouldShowName((Entity)entAsT, d) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof Player && livingEntity != this.client.player) && d <= 4096.0) {
            matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
            if (d < 100.0 && livingEntity instanceof Player && livingEntity.level().getScoreboard().getDisplayObjective(DisplaySlot.BELOW_NAME) != null) {
                matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
            }
        }
        matrixStack.mulPose((Quaternionfc)this.entityRenderDispatcher.camera.rotation());
        matrixStack.scale(scale, -scale, scale);
        matrixStack.translate(0.0, -((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
        Font textRenderer = Minecraft.getInstance().font;
        float x = (float)(-textRenderer.width(healthText)) / 2.0f;
        Font.DisplayMode textLayerType = isObstructed ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL;
        int backgroundColor = ((ModConfig)ModConfig.HANDLER.instance()).render_number_display_background_color ? ((ModConfig)ModConfig.HANDLER.instance()).number_display_background_color.getRGB() : 0;
        int textColor = ((ModConfig)ModConfig.HANDLER.instance()).number_color.getRGB();
        int opacity = ((ModConfig)ModConfig.HANDLER.instance()).health_bar_opacity;
        textColor = textColor & 0xFFFFFF | opacity * 255 / 100 << 24;
        orderedRenderCommandQueue.submitText(matrixStack, x, 0.0f, Component.literal((String)healthText).getVisualOrderText(), ((ModConfig)ModConfig.HANDLER.instance()).render_number_display_shadow, textLayerType, 0xF000F0, textColor, backgroundColor, 0);
        matrixStack.popPose();
    }

    @Unique
    private void renderArmorPoints(LivingEntity livingEntity, float yaw, float tickDelta, PoseStack matrixStack, SubmitNodeCollector orderedRenderCommandQueue) {
        double d = this.entityRenderDispatcher.distanceToSqr((Entity)livingEntity);
        LivingEntity entAsT = livingEntity;
        int armor = Mth.ceil((float)livingEntity.getArmorValue());
        int maxArmor = Mth.ceil((float)livingEntity.getArmorValue());
        if (maxArmor == 0) {
            return;
        }
        int armorPoints = Mth.ceil((float)((float)armor / 2.0f));
        boolean lastPointHalf = (armor & 1) == 1;
        int pointsTotal = 10;
        int pointsPerRow = ((ModConfig)ModConfig.HANDLER.instance()).icons_per_row;
        int pixelsTotal = Math.min(pointsTotal, pointsPerRow) * 8 + 1;
        float maxX = (float)pixelsTotal / 2.0f;
        float scale = ((ModConfig)ModConfig.HANDLER.instance()).size;
        boolean isObstructed = ((ModConfig)ModConfig.HANDLER.instance()).show_through_walls;
        double h = 0.0;
        for (int isDrawingEmpty = 0; isDrawingEmpty < 2; ++isDrawingEmpty) {
            SubmitNodeCollector targetQueue = isObstructed ? orderedRenderCommandQueue.order(isDrawingEmpty + 2) : orderedRenderCommandQueue;
            for (int pointCount = 0; pointCount < pointsTotal; ++pointCount) {
                ArmorTypeEnum type;
                if (pointCount % pointsPerRow == 0) {
                    h = scale * 10.0f * (float)((pointCount / 2 + pointsPerRow - 1) / pointsPerRow);
                }
                matrixStack.pushPose();
                int extraHeight = (int)(((livingEntity.getMaxHealth() + livingEntity.getAbsorptionAmount()) / 2.0f + (float)pointsPerRow - 1.0f) / (float)pointsPerRow);
                matrixStack.translate(0.0, (double)(livingEntity.getBbHeight() + 0.75f + scale * 10.0f * (float)(extraHeight - 1)) + h, 0.0);
                if ((this.shouldShowName((Entity)entAsT, d) || ((ModConfig)ModConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof Player && livingEntity != this.client.player) && d <= 4096.0) {
                    matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
                    if (d < 100.0 && livingEntity instanceof Player && livingEntity.level().getScoreboard().getDisplayObjective(DisplaySlot.BELOW_NAME) != null) {
                        matrixStack.translate(0.0, (double)(10.349999f * scale), 0.0);
                    }
                }
                matrixStack.mulPose((Quaternionfc)this.entityRenderDispatcher.camera.rotation());
                matrixStack.scale(-scale, scale, scale);
                matrixStack.translate(0.0, ((ModConfig)ModConfig.HANDLER.instance()).display_offset, 0.0);
                float x = maxX - (float)(pointCount % pointsPerRow * 8);
                ArmorTypeEnum armorTypeEnum = isDrawingEmpty == 0 ? ArmorTypeEnum.EMPTY : (pointCount < armorPoints ? (pointCount == armorPoints - 1 && lastPointHalf ? ArmorTypeEnum.HALF : ArmorTypeEnum.FULL) : (type = null));
                if (type != null) {
                    ResourceLocation armorTextureId = type.icon;
                    RenderType renderLayer = isObstructed ? RenderType.textSeeThrough((ResourceLocation)armorTextureId) : RenderType.text((ResourceLocation)armorTextureId);
                    ArmorTypeEnum renderType = type;
                    float opacity = (float)((ModConfig)ModConfig.HANDLER.instance()).health_bar_opacity / 100.0f;
                    targetQueue.submitCustomGeometry(matrixStack, renderLayer, (matricesEntry, vertexConsumer) -> {
                        Matrix4f m = matricesEntry.pose();
                        RenderUtils.drawArmor(m, vertexConsumer, x, renderType, opacity, d, isObstructed);
                    });
                }
                matrixStack.popPose();
            }
        }
    }
}

