/*
 * Decompiled with CFR 0.152.
 */
package neoforge.io.github.adytech99.healthindicators.neoforge;

import neoforge.io.github.adytech99.healthindicators.HealthIndicatorsCommon;
import neoforge.io.github.adytech99.healthindicators.config.Config;
import neoforge.io.github.adytech99.healthindicators.config.ModConfig;
import neoforge.io.github.adytech99.healthindicators.neoforge.commands.ModCommands;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;

@Mod(value="healthindicators")
@EventBusSubscriber(value={Dist.CLIENT}, modid="healthindicators")
public final class HealthIndicatorsNeoForge {
    public static Minecraft client = Minecraft.getInstance();
    public static final Lazy<KeyMapping> HEARTS_RENDERING_ENABLED = Lazy.of(() -> new KeyMapping("key.healthindicators.renderingEnabled", 263, HealthIndicatorsCommon.HEALTH_INDICATORS_CATEGORY));
    public static final Lazy<KeyMapping> ARMOR_RENDERING_ENABLED = Lazy.of(() -> new KeyMapping("key.healthindicators.armorRenderingEnabled", 344, HealthIndicatorsCommon.HEALTH_INDICATORS_CATEGORY));
    public static final Lazy<KeyMapping> OVERRIDE_ALL_FILTERS = Lazy.of(() -> new KeyMapping("key.healthindicators.overrideAllFilters", 262, HealthIndicatorsCommon.HEALTH_INDICATORS_CATEGORY));
    public static final Lazy<KeyMapping> INCREASE_HEART_OFFSET = Lazy.of(() -> new KeyMapping("key.healthindicators.increaseHeartOffset", 265, HealthIndicatorsCommon.HEALTH_INDICATORS_CATEGORY));
    public static final Lazy<KeyMapping> DECREASE_HEART_OFFSET = Lazy.of(() -> new KeyMapping("key.healthindicators.decreaseHeartOffset", 264, HealthIndicatorsCommon.HEALTH_INDICATORS_CATEGORY));
    public static final Lazy<KeyMapping> OPEN_CONFIG_SCREEN = Lazy.of(() -> new KeyMapping("key.healthindicators.openModMenuConfig", 73, HealthIndicatorsCommon.HEALTH_INDICATORS_CATEGORY));

    public HealthIndicatorsNeoForge() {
        HealthIndicatorsCommon.init();
        HealthIndicatorsCommon.client = client;
        if (((ModConfig)ModConfig.HANDLER.instance()).enable_commands) {
            NeoForge.EVENT_BUS.addListener(ModCommands::onRegisterCommands);
        }
        NeoForge.EVENT_BUS.addListener(this::onClientTick);
    }

    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)HEARTS_RENDERING_ENABLED.get());
        event.register((KeyMapping)INCREASE_HEART_OFFSET.get());
        event.register((KeyMapping)DECREASE_HEART_OFFSET.get());
        event.register((KeyMapping)OVERRIDE_ALL_FILTERS.get());
        event.register((KeyMapping)ARMOR_RENDERING_ENABLED.get());
        event.register((KeyMapping)OPEN_CONFIG_SCREEN.get());
    }

    public void onClientTick(ClientTickEvent.Post event) {
        HealthIndicatorsCommon.tick();
        while (((KeyMapping)HEARTS_RENDERING_ENABLED.get()).consumeClick()) {
            HealthIndicatorsCommon.enableHeartsRendering();
        }
        while (((KeyMapping)ARMOR_RENDERING_ENABLED.get()).consumeClick()) {
            HealthIndicatorsCommon.enableArmorRendering();
        }
        while (((KeyMapping)INCREASE_HEART_OFFSET.get()).consumeClick()) {
            HealthIndicatorsCommon.increaseOffset();
        }
        while (((KeyMapping)DECREASE_HEART_OFFSET.get()).consumeClick()) {
            HealthIndicatorsCommon.decreaseOffset();
        }
        if (((KeyMapping)OVERRIDE_ALL_FILTERS.get()).isDown()) {
            HealthIndicatorsCommon.overrideFilters();
        } else if (Config.getOverrideAllFiltersEnabled()) {
            HealthIndicatorsCommon.disableOverrideFilters();
        }
        if (((KeyMapping)OPEN_CONFIG_SCREEN.get()).consumeClick()) {
            HealthIndicatorsCommon.openConfigScreen();
        }
    }

    @SubscribeEvent
    public static void constructMod(FMLConstructModEvent event) {
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> new IConfigScreenFactory(){

            @NotNull
            public Screen createScreen(@NotNull ModContainer arg, @NotNull Screen arg2) {
                return ModConfig.createScreen(arg2);
            }
        });
    }
}

