/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.client.util.DisplayEntryRenderHelper;
import fuzs.pickupnotifier.config.ClientConfig;
import fuzs.pickupnotifier.config.CombineEntries;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_9779;

public final class ItemDisplayEntry
extends DisplayEntry<class_1799> {
    private static final int ITEM_STACK_POP_TIME = 5;

    public ItemDisplayEntry(class_1799 itemStack, int displayAmount) {
        super(itemStack.method_7972(), displayAmount, itemStack.method_7932());
        ((class_1799)this.item).method_7912(5);
    }

    @Override
    protected class_2561 getEntryName(class_1799 itemStack) {
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.combineEntries == CombineEntries.ALWAYS) {
            return itemStack.method_7909().method_7864(itemStack);
        }
        return itemStack.method_7964();
    }

    @Override
    public void tick() {
        super.tick();
        if (((class_1799)this.item).method_7965() > 0) {
            ((class_1799)this.item).method_7912(((class_1799)this.item).method_7965() - 1);
        }
    }

    @Override
    public DisplayEntry<?> mergeWith(DisplayEntry<?> otherDisplayEntry) {
        return new ItemDisplayEntry((class_1799)this.item, this.getDisplayAmount() + otherDisplayEntry.getDisplayAmount());
    }

    @Override
    protected void appendTextComponents(List<class_2561> components, boolean reverse) {
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.inventoryCount) {
            class_5250 inventoryCountComponent = class_2561.method_43470((String)String.valueOf(this.getInventoryCount()));
            components.add((class_2561)class_2561.method_43470((String)"(").method_10852((class_2561)inventoryCountComponent).method_27693(")"));
        }
        super.appendTextComponents(components, reverse);
    }

    private int getInventoryCount() {
        class_1661 inventory = class_310.method_1551().field_1724.method_31548();
        return class_1262.method_29234((class_1263)inventory, itemStackX -> class_1799.method_7984((class_1799)((class_1799)this.item), (class_1799)itemStackX), (int)0, (boolean)true);
    }

    @Override
    protected void renderSprite(class_332 guiGraphics, class_327 font, int posX, int posY, float alpha) {
        if (((class_1799)this.item).method_7965() > 0) {
            class_9779 deltaTracker = class_310.method_1551().method_61966();
            float popTime = (float)((class_1799)this.item).method_7965() - deltaTracker.method_60637(false);
            float popTimeScale = 1.0f + popTime / 5.0f;
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate((float)(posX + 8), (float)(posY + 12));
            guiGraphics.method_51448().scale(1.0f / popTimeScale, (popTimeScale + 1.0f) / 2.0f);
            guiGraphics.method_51448().translate((float)(-(posX + 8)), (float)(-(posY + 12)));
        }
        DisplayEntryRenderHelper.renderItem(guiGraphics, (class_1799)this.item, posX, posY, alpha);
        if (((class_1799)this.item).method_7965() > 0) {
            guiGraphics.method_51448().popMatrix();
        }
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.isSprite()) {
            DisplayEntryRenderHelper.renderGuiItemDecorations(guiGraphics, font, this.getDisplayAmount(), posX, posY, alpha);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.combineEntries != CombineEntries.NEVER && obj instanceof ItemDisplayEntry) {
            ItemDisplayEntry itemDisplayEntry = (ItemDisplayEntry)obj;
            if (class_1799.method_7984((class_1799)((class_1799)this.item), (class_1799)((class_1799)itemDisplayEntry.item)) && Objects.equals(((class_1799)this.item).method_7932(), ((class_1799)itemDisplayEntry.item).method_7932()) && Objects.equals(((class_1799)this.item).method_7942(), ((class_1799)itemDisplayEntry.item).method_7942())) {
                if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.combineEntries == CombineEntries.ALWAYS) {
                    return true;
                }
                return Objects.equals(((class_1799)this.item).method_7964(), ((class_1799)itemDisplayEntry.item).method_7964());
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((class_1799)this.item).method_7909().hashCode();
    }
}

