/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.packs;

import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.client.gui.NewHealthBarRenderer;
import fuzs.puzzleslib.api.client.packs.v1.NativeImageHelper;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_329;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_7367;
import net.minecraft.class_7654;
import net.minecraft.class_7948;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class DynamicallyCopiedPackResources
extends AbstractModPackResources {
    private final class_3300 resourceManager;
    private final class_3268 vanillaPackResources;
    private final Map<class_2960, TextureCopy> textures;

    protected DynamicallyCopiedPackResources(TextureCopy ... textures) {
        class_310 minecraft = class_310.method_1551();
        this.resourceManager = minecraft.method_1478();
        this.vanillaPackResources = minecraft.method_45573();
        this.textures = Stream.of(textures).collect(Collectors.toMap(TextureCopy::destinationLocation, Function.identity()));
    }

    public static Supplier<AbstractModPackResources> create(TextureCopy ... textures) {
        return () -> new DynamicallyCopiedPackResources(textures);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 resourceLocation) {
        if (!this.textures.containsKey(resourceLocation)) return null;
        TextureCopy textureCopy = this.textures.get(resourceLocation);
        Optional vanillaResource = this.resourceManager.method_14486(textureCopy.vanillaLocation());
        if (!vanillaResource.isPresent()) return null;
        try (class_1011 nativeImage = class_1011.method_4309((InputStream)((class_3298)vanillaResource.get()).method_14482());){
            if (nativeImage.method_4307() / nativeImage.method_4323() == textureCopy.vanillaImageWidth() / textureCopy.vanillaImageHeight()) return () -> ((class_3298)((class_3298)vanillaResource.get())).method_14482();
            class_7367 class_73672 = this.vanillaPackResources.method_14405(packType, textureCopy.vanillaLocation());
            return class_73672;
        }
        catch (IOException iOException) {
        }
        return () -> ((class_3298)((class_3298)vanillaResource.get())).method_14482();
    }

    public Set<String> method_14406(class_3264 packType) {
        return Collections.singleton("overflowingbars");
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
        String prefix = "textures/gui/sprites";
        if (path.startsWith(prefix)) {
            int[] dyes;
            class_7654 textureIdConverter = class_7948.field_42075;
            for (int dye : dyes = new int[]{19841, 31863, 291073, 16749568, 11867904, 10098784}) {
                Stream.of(class_329.class_6411.values()).flatMap(NewHealthBarRenderer::getHeartTypeTextureLocations).forEach(resourceLocation -> {
                    class_2960 resourceLocation1 = OverflowingBars.id(resourceLocation.method_12832()).method_48331("_" + dye);
                    class_2960 resourceLocation2 = resourceLocation.method_45138(prefix + "/").method_48331(".png");
                    Optional resource = this.resourceManager.method_14486(resourceLocation2);
                    if (resource.isPresent()) {
                        class_2960 resourceLocation3 = resourceLocation1.method_45138(prefix + "/").method_48331(".png");
                        resourceOutput.accept((Object)resourceLocation3, () -> DynamicallyCopiedPackResources.makeImageTranslucent((class_7367<InputStream>)((class_7367)() -> ((class_3298)((class_3298)resource.get())).method_14482()), dye));
                    }
                });
            }
        }
    }

    private static InputStream makeImageTranslucent(class_7367<InputStream> supplier, int dye) throws IOException {
        try (InputStream inputStream = (InputStream)supplier.get();){
            ByteArrayInputStream byteArrayInputStream;
            block14: {
                class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                try {
                    for (int x = 0; x < nativeImage.method_4307(); ++x) {
                        for (int y = 0; y < nativeImage.method_4323(); ++y) {
                            int pixel = nativeImage.method_61940(x, y);
                            pixel = DynamicallyCopiedPackResources.colorizePixel(pixel, dye);
                            nativeImage.method_61941(x, y, pixel);
                        }
                    }
                    byteArrayInputStream = new ByteArrayInputStream(NativeImageHelper.asByteArray((class_1011)nativeImage));
                    if (nativeImage == null) break block14;
                }
                catch (Throwable throwable) {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeImage.close();
            }
            return byteArrayInputStream;
        }
    }

    public static int applyBlend(int greyscale, int dye) {
        int r = DynamicallyCopiedPackResources.softLightInt(class_9848.method_61327((int)greyscale), class_9848.method_61327((int)dye));
        int g = DynamicallyCopiedPackResources.softLightInt(class_9848.method_61329((int)greyscale), class_9848.method_61329((int)dye));
        int b = DynamicallyCopiedPackResources.softLightInt(class_9848.method_61331((int)greyscale), class_9848.method_61331((int)dye));
        return class_9848.method_61324((int)class_9848.method_61320((int)greyscale), (int)b, (int)g, (int)r);
    }

    public static int softLightInt(int a, int b) {
        return class_3532.method_15340((int)((int)(DynamicallyCopiedPackResources.softLight((double)a / 255.0, (double)b / 255.0) * 255.0)), (int)0, (int)255);
    }

    public static double softLight(double a, double b) {
        if (b < 0.5) {
            return 2.0 * a * b + a * a * (1.0 - 2.0 * b);
        }
        return 2.0 * a * (255.0 - b) + Math.sqrt(a) * (2.0 * b - 1.0);
    }

    public static int lerpColor(int greyscale, int dye, double range) {
        int blueBase = (int)((double)class_9848.method_61331((int)greyscale) + (double)(class_9848.method_61331((int)dye) - class_9848.method_61331((int)greyscale)) * range);
        int greenBase = (int)((double)class_9848.method_61329((int)greyscale) + (double)(class_9848.method_61329((int)dye) - class_9848.method_61329((int)greyscale)) * range);
        int redBase = (int)((double)class_9848.method_61327((int)greyscale) + (double)(class_9848.method_61327((int)dye) - class_9848.method_61327((int)greyscale)) * range);
        return class_9848.method_61324((int)class_9848.method_61320((int)greyscale), (int)blueBase, (int)greenBase, (int)redBase);
    }

    public static IntUnaryOperator getColorOverlayOperator(int color) {
        return DynamicallyCopiedPackResources.getColorOverlayOperator(class_9848.method_61327((int)color), class_9848.method_61329((int)color), class_9848.method_61331((int)color));
    }

    public static IntUnaryOperator getColorOverlayOperator(int redColor, int greenColor, int blueColor) {
        return pixel -> {
            int alphaBase = class_9848.method_61320((int)pixel);
            if (alphaBase == 0) {
                return pixel;
            }
            int blueBase = class_9848.method_61331((int)pixel);
            int greenBase = class_9848.method_61329((int)pixel);
            int redBase = class_9848.method_61327((int)pixel);
            int blue = blueBase < 128 ? 2 * (blueBase * blueColor / 255) : 255 - 2 * (255 - blueBase) * (alphaBase - blueColor) / 255;
            int green = greenBase < 128 ? 2 * (greenBase * greenColor / 255) : 255 - 2 * (255 - greenBase) * (alphaBase - greenColor) / 255;
            int red = redBase < 128 ? 2 * (redBase * redColor / 255) : 255 - 2 * (255 - redBase) * (alphaBase - redColor) / 255;
            return class_9848.method_61324((int)alphaBase, (int)blue, (int)green, (int)red);
        };
    }

    public static int colorizePixel(int argb, int dye) {
        float hue = Color.RGBtoHSB(class_9848.method_61327((int)dye), class_9848.method_61329((int)dye), class_9848.method_61331((int)dye), null)[0];
        int alpha = argb & 0xFF000000;
        int grayLevel = DynamicallyCopiedPackResources.toGreyscale(argb) & 0xFF;
        float brightness = (float)grayLevel / 255.0f;
        int rgb = Color.HSBtoRGB(hue, 1.0f, brightness);
        argb = rgb & 0xFFFFFF | alpha;
        return argb;
    }

    public static int toGreyscale(int color) {
        int alpha = class_9848.method_61320((int)color);
        if (alpha == 0) {
            return color;
        }
        int red = class_9848.method_61327((int)color);
        int green = class_9848.method_61329((int)color);
        int blue = class_9848.method_61331((int)color);
        int avg = (int)(0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue);
        return alpha << 24 | avg << 16 | avg << 8 | avg;
    }

    public record TextureCopy(class_2960 vanillaLocation, class_2960 destinationLocation, int vanillaImageWidth, int vanillaImageHeight) {
        public TextureCopy {
            if (vanillaLocation.method_12836().equals(destinationLocation.method_12836())) {
                throw new IllegalStateException("%s and %s share same namespace".formatted(vanillaLocation, destinationLocation));
            }
            if (!vanillaLocation.method_12832().endsWith(".png")) {
                throw new IllegalArgumentException("%s is no texture location".formatted(vanillaLocation));
            }
            if (!destinationLocation.method_12832().endsWith(".png")) {
                throw new IllegalArgumentException("%s is no texture location".formatted(destinationLocation));
            }
        }
    }
}

