/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.common.gui;

import betteradvancements.common.advancements.BetterDisplayInfo;
import betteradvancements.common.advancements.BetterDisplayInfoRegistry;
import betteradvancements.common.gui.BetterAdvancementTabType;
import betteradvancements.common.gui.BetterAdvancementWidget;
import betteradvancements.common.gui.BetterAdvancementsScreen;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_12079;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_8779;
import net.minecraft.class_8781;

public class BetterAdvancementTab {
    public static boolean doFade = true;
    public static final Map<class_8779, class_3545<Integer, Integer>> scrollHistory = Maps.newLinkedHashMap();
    private final class_310 minecraft;
    private final BetterAdvancementsScreen screen;
    private final BetterAdvancementTabType type;
    private final int index;
    private final class_8781 rootNode;
    private final class_185 display;
    private final class_1799 icon;
    private final class_2561 title;
    private final BetterAdvancementWidget root;
    protected final Map<class_8779, BetterAdvancementWidget> widgets = Maps.newLinkedHashMap();
    private final BetterDisplayInfoRegistry betterDisplayInfos;
    protected int scrollX;
    protected int scrollY;
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private float fade;
    private boolean centered;

    public BetterAdvancementTab(class_310 mc, BetterAdvancementsScreen betterAdvancementsScreen, BetterAdvancementTabType type, int index, class_8781 advancementNode, class_185 displayInfo) {
        this.minecraft = mc;
        this.screen = betterAdvancementsScreen;
        this.type = type;
        this.index = index;
        this.rootNode = advancementNode;
        this.display = displayInfo;
        this.icon = displayInfo.method_821();
        this.title = displayInfo.method_811();
        this.betterDisplayInfos = new BetterDisplayInfoRegistry(advancementNode);
        this.root = new BetterAdvancementWidget(this, mc, advancementNode, displayInfo);
        this.addWidget(this.root, advancementNode.method_53649());
    }

    public class_8781 getRootNode() {
        return this.rootNode;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public void drawTab(class_332 guiGraphics, int left, int top, int width, int height, boolean selected) {
        this.type.draw(guiGraphics, left, top, width, height, selected, this.index);
    }

    public void drawIcon(class_332 guiGraphics, int left, int top, int width, int height) {
        this.type.drawIcon(guiGraphics, left, top, width, height, this.index, this.icon);
    }

    public void drawContents(class_332 guiGraphics, int left, int top, int width, int height, float zoom) {
        if (!this.centered) {
            this.scrollX = (width - (this.maxX + this.minX)) / 2;
            this.scrollY = (height - (this.maxY + this.minY)) / 2;
            this.centered = true;
        }
        guiGraphics.method_44379(left, top, left + width, top + height);
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)left, (float)top);
        class_2960 resourcelocation = this.display.method_812().map(class_12079.class_10726::comp_3627).orElse(class_1060.field_5285);
        int i = this.scrollX % 16;
        int j = this.scrollY % 16;
        for (int k = -1; k <= 1 + width / 16; ++k) {
            int l;
            for (l = -1; l <= height / 16; ++l) {
                guiGraphics.method_25290(class_10799.field_56883, resourcelocation, i + 16 * k, j + 16 * l, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            guiGraphics.method_25290(class_10799.field_56883, resourcelocation, i + 16 * k, j + 16 * l, 0.0f, 0.0f, 16, height % 16, 16, 16);
        }
        guiGraphics.method_51448().scale(zoom, zoom);
        this.root.drawConnectivity(guiGraphics, this.scrollX, this.scrollY, true);
        this.root.drawConnectivity(guiGraphics, this.scrollX, this.scrollY, false);
        this.root.draw(guiGraphics, this.scrollX, this.scrollY);
        guiGraphics.method_51448().popMatrix();
        guiGraphics.method_44380();
    }

    public void drawToolTips(class_332 guiGraphics, int mouseX, int mouseY, int left, int top, int width, int height, float zoom) {
        guiGraphics.method_25294(0, 0, width, height, class_3532.method_15375((float)(this.fade * 255.0f)) << 24);
        boolean flag = false;
        if (mouseX > 0 && mouseX < width && mouseY > 0 && mouseY < height) {
            for (BetterAdvancementWidget betterAdvancementWidget : this.widgets.values()) {
                if (!betterAdvancementWidget.isMouseOver(this.scrollX, this.scrollY, mouseX, mouseY, zoom)) continue;
                flag = true;
                betterAdvancementWidget.drawHover(guiGraphics, this.scrollX, this.scrollY, this.fade, left, top, zoom);
                break;
            }
        }
        this.fade = doFade && flag ? class_3532.method_15363((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : class_3532.method_15363((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
    }

    public boolean isMouseOver(int left, int top, int width, int height, double mouseX, double mouseY) {
        return this.type.isMouseOver(left, top, width, height, this.index, mouseX, mouseY);
    }

    public static BetterAdvancementTab create(class_310 mc, BetterAdvancementsScreen betterAdvancementsScreen, int index, class_8781 advancementNode, int width, int height) {
        Optional optional = advancementNode.method_53647().comp_1913();
        if (optional.isEmpty()) {
            return null;
        }
        BetterAdvancementTabType advancementTabType = BetterAdvancementTabType.getTabType(width, height, index);
        if (advancementTabType == null) {
            return null;
        }
        return new BetterAdvancementTab(mc, betterAdvancementsScreen, advancementTabType, index, advancementNode, (class_185)optional.get());
    }

    public void scroll(double scrollX, double scrollY, int width, int height) {
        if (this.maxX - this.minX > width) {
            this.scrollX = (int)Math.round(class_3532.method_15350((double)((double)this.scrollX + scrollX), (double)(-(this.maxX - width)), (double)(-this.minX)));
        }
        if (this.maxY - this.minY > height) {
            this.scrollY = (int)Math.round(class_3532.method_15350((double)((double)this.scrollY + scrollY), (double)(-(this.maxY - height)), (double)(-this.minY)));
        }
    }

    public void addAdvancement(class_8781 advancementNode) {
        Optional optional = advancementNode.method_53647().comp_1913();
        if (optional.isPresent()) {
            BetterAdvancementWidget betterAdvancementEntryScreen = new BetterAdvancementWidget(this, this.minecraft, advancementNode, (class_185)optional.get());
            this.addWidget(betterAdvancementEntryScreen, advancementNode.method_53649());
        }
    }

    private void addWidget(BetterAdvancementWidget betterAdvancementEntryScreen, class_8779 advancementHolder) {
        this.widgets.put(advancementHolder, betterAdvancementEntryScreen);
        int left = betterAdvancementEntryScreen.getX();
        int right = left + 28;
        int top = betterAdvancementEntryScreen.getY();
        int bottom = top + 27;
        this.minX = Math.min(this.minX, left);
        this.maxX = Math.max(this.maxX, right);
        this.minY = Math.min(this.minY, top);
        this.maxY = Math.max(this.maxY, bottom);
        for (BetterAdvancementWidget gui : this.widgets.values()) {
            gui.attachToParent();
        }
    }

    public BetterAdvancementWidget getWidget(class_8779 advancementHolder) {
        return this.widgets.get(advancementHolder);
    }

    public BetterAdvancementsScreen getScreen() {
        return this.screen;
    }

    public BetterDisplayInfo getBetterDisplayInfo(class_8781 advancementNode) {
        return this.betterDisplayInfos.get(advancementNode.method_53649());
    }

    public void storeScroll() {
        scrollHistory.put(this.rootNode.method_53649(), (class_3545<Integer, Integer>)new class_3545((Object)this.scrollX, (Object)this.scrollY));
    }

    public void loadScroll() {
        class_3545<Integer, Integer> scroll = scrollHistory.get(this.rootNode.method_53649());
        if (scroll != null) {
            this.centered = true;
            this.scrollX = (Integer)scroll.method_15442();
            this.scrollY = (Integer)scroll.method_15441();
        }
    }
}

