/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.gui;

import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.client.gui.BarOverlayRenderer;
import fuzs.overflowingbars.config.ClientConfig;
import net.minecraft.class_10209;
import net.minecraft.class_10799;
import net.minecraft.class_1294;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class HealthBarRenderer {
    public static final HealthBarRenderer INSTANCE = new HealthBarRenderer();
    private final class_5819 random = class_5819.method_43047();
    private int tickCount;
    private int lastHealth;
    private int displayHealth;
    private long lastHealthTime;
    private long healthBlinkTime;

    public void onStartTick(class_310 minecraft) {
        ++this.tickCount;
    }

    public void renderPlayerHealth(class_332 guiGraphics, int posX, int posY, class_1657 player) {
        class_10209.method_64146().method_15396(OverflowingBars.id("health").toString());
        int currentHealth = class_3532.method_15386((float)player.method_6032());
        boolean blink = this.healthBlinkTime > (long)this.tickCount && (this.healthBlinkTime - (long)this.tickCount) / 3L % 2L == 1L;
        long millis = class_156.method_658();
        if (currentHealth < this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = millis;
            this.healthBlinkTime = this.tickCount + 20;
        } else if (currentHealth > this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = millis;
            this.healthBlinkTime = this.tickCount + 10;
        }
        if (millis - this.lastHealthTime > 1000L) {
            this.displayHealth = currentHealth;
            this.lastHealthTime = millis;
        }
        this.lastHealth = currentHealth;
        int displayHealth = this.displayHealth;
        this.random.method_43052((long)(this.tickCount * 312871));
        float maxHealth = Math.max((float)player.method_45325(class_5134.field_23716), (float)Math.max(displayHealth, currentHealth));
        int currentAbsorption = class_3532.method_15386((float)player.method_6067());
        int heartOffsetByRegen = -1;
        if (player.method_6059(class_1294.field_5924)) {
            heartOffsetByRegen = this.tickCount % class_3532.method_15386((float)(Math.min(20.0f, maxHealth) + 5.0f));
        }
        this.renderHearts(guiGraphics, player, posX, posY, heartOffsetByRegen, maxHealth, currentHealth, displayHealth, currentAbsorption, blink);
        class_10209.method_64146().method_15407();
    }

    private void renderHearts(class_332 guiGraphics, class_1657 player, int posX, int posY, int heartOffsetByRegen, float maxHealth, int currentHealth, int displayHealth, int currentAbsorptionHealth, boolean blink) {
        boolean hardcore = player.method_73183().method_8401().method_152();
        int normalHearts = Math.min(10, class_3532.method_15384((double)((double)maxHealth / 2.0)));
        int maxAbsorptionHearts = 20 - normalHearts;
        int absorptionHearts = Math.min(20 - normalHearts, class_3532.method_15384((double)((double)currentAbsorptionHealth / 2.0)));
        for (int currentHeart = 0; currentHeart < normalHearts + absorptionHearts; ++currentHeart) {
            boolean orange;
            boolean halfHeart;
            int currentAbsorption;
            int currentPosX = posX + currentHeart % 10 * 8;
            int currentPosY = posY - currentHeart / 10 * 10;
            if (currentHealth + currentAbsorptionHealth <= 4) {
                currentPosY += this.random.method_43048(2);
            }
            if (currentHeart < normalHearts && heartOffsetByRegen == currentHeart) {
                currentPosY -= 2;
            }
            ModHeartType.CONTAINER.renderHeart(guiGraphics, currentPosX, currentPosY, blink, false, hardcore);
            if (currentHeart >= normalHearts && (currentAbsorption = currentHeart * 2 - normalHearts * 2) < currentAbsorptionHealth) {
                boolean orange2;
                int maxAbsorptionHealth = maxAbsorptionHearts * 2;
                boolean halfHeart2 = currentAbsorption + 1 == currentAbsorptionHealth % maxAbsorptionHealth;
                boolean bl = orange2 = currentAbsorptionHealth > maxAbsorptionHealth && currentAbsorption + 1 <= (currentAbsorptionHealth - 1) % maxAbsorptionHealth + 1;
                if (halfHeart2 && orange2) {
                    ModHeartType.forPlayer(player, true, false).renderHeart(guiGraphics, currentPosX, currentPosY, false, false, hardcore);
                }
                ModHeartType.forPlayer(player, true, orange2).renderHeart(guiGraphics, currentPosX, currentPosY, false, halfHeart2, hardcore);
            }
            if (blink && currentHeart * 2 < Math.min(20, displayHealth)) {
                halfHeart = currentHeart * 2 + 1 == (displayHealth - 1) % 20 + 1;
                boolean bl = orange = displayHealth > 20 && currentHeart * 2 + 1 <= (displayHealth - 1) % 20 + 1;
                if (halfHeart && orange) {
                    ModHeartType.forPlayer(player, false, false).renderHeart(guiGraphics, currentPosX, currentPosY, true, false, hardcore);
                }
                ModHeartType heartType = ModHeartType.forPlayer(player, false, orange || ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.colorizeFirstRow && currentHeart * 2 + 1 <= (displayHealth - 1) % 20 + 1);
                heartType.renderHeart(guiGraphics, currentPosX, currentPosY, true, halfHeart, hardcore);
            }
            if (currentHeart * 2 >= Math.min(20, currentHealth)) continue;
            halfHeart = currentHeart * 2 + 1 == (currentHealth - 1) % 20 + 1;
            boolean bl = orange = currentHealth > 20 && currentHeart * 2 + 1 <= (currentHealth - 1) % 20 + 1;
            if (halfHeart && orange) {
                ModHeartType.forPlayer(player, false, false).renderHeart(guiGraphics, currentPosX, currentPosY, false, false, hardcore);
            }
            ModHeartType heartType = ModHeartType.forPlayer(player, false, orange || ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.colorizeFirstRow && currentHeart * 2 + 1 <= (currentHealth - 1) % 20 + 1);
            heartType.renderHeart(guiGraphics, currentPosX, currentPosY, false, halfHeart, hardcore);
        }
    }

    static enum ModHeartType {
        CONTAINER(class_329.class_6411.field_33944),
        NORMAL(class_329.class_6411.field_33945),
        POISONED(class_329.class_6411.field_33946),
        WITHERED(class_329.class_6411.field_33947),
        ABSORBING(class_329.class_6411.field_33948),
        FROZEN(class_329.class_6411.field_33949),
        ORANGE(0, 3, 4, BarOverlayRenderer.OVERFLOWING_ICONS_LOCATION, true);

        @Nullable
        private final class_329.class_6411 heartType;
        private final int textureIndexX;
        private final int textureIndexY;
        private final int hardcoreIndexY;
        private final class_2960 textureSheet;
        private final boolean canBlink;

        private ModHeartType(class_329.class_6411 heartType) {
            this.heartType = heartType;
            this.textureIndexX = -1;
            this.textureIndexY = -1;
            this.hardcoreIndexY = -1;
            this.textureSheet = null;
            this.canBlink = false;
        }

        private ModHeartType(int textureIndexX, int textureIndexY, int hardcoreIndexY, class_2960 textureSheet, boolean blink) {
            this.heartType = null;
            this.textureIndexX = textureIndexX;
            this.textureIndexY = textureIndexY;
            this.hardcoreIndexY = hardcoreIndexY;
            this.textureSheet = textureSheet;
            this.canBlink = blink;
        }

        public void renderHeart(class_332 guiGraphics, int posX, int posY, boolean blinking, boolean halfHeart, boolean hardcore) {
            if (this.heartType != null) {
                class_2960 resourceLocation = this.heartType.method_52705(hardcore, halfHeart, blinking);
                guiGraphics.method_52706(class_10799.field_56883, resourceLocation, posX, posY, 9, 9);
            } else {
                guiGraphics.method_25290(class_10799.field_56883, this.textureSheet, posX, posY, (float)this.getX(halfHeart, blinking), (float)this.getY(hardcore), 9, 9, 256, 256);
            }
        }

        public int getX(boolean halfHeart, boolean blinking) {
            int i;
            if (this == CONTAINER) {
                i = blinking ? 1 : 0;
            } else {
                int j = halfHeart ? 1 : 0;
                int k = this.canBlink && blinking ? 2 : 0;
                i = j + k;
            }
            return (this == ORANGE ? 0 : 16) + (this.textureIndexX * 2 + i) * 9;
        }

        public int getY(boolean hardcore) {
            return (hardcore ? this.hardcoreIndexY : this.textureIndexY) * 9;
        }

        public static ModHeartType forPlayer(class_1657 player, boolean absorbing, boolean orange) {
            if (player.method_6059(class_1294.field_5920)) {
                return WITHERED;
            }
            if (player.method_6059(class_1294.field_5899)) {
                return POISONED;
            }
            if (player.method_32314()) {
                return FROZEN;
            }
            boolean inverse = ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.inverseColoring;
            if (orange) {
                return absorbing || !inverse ? ORANGE : NORMAL;
            }
            return absorbing ? ABSORBING : (inverse ? ORANGE : NORMAL);
        }
    }
}

