/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.gui;

import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.config.ClientConfig;
import fuzs.puzzleslib.api.client.gui.v2.GuiGraphicsHelper;
import java.util.stream.IntStream;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9848;

public class RowCountRenderer {
    private static final class_2960 TINY_NUMBERS_LOCATION = OverflowingBars.id("textures/font/tiny_numbers.png");

    public static void drawBarRowCount(class_332 guiGraphics, int posX, int posY, int barValue, boolean left) {
        RowCountRenderer.drawBarRowCount(guiGraphics, posX, posY, barValue, left, 20);
    }

    public static void drawBarRowCount(class_332 guiGraphics, int posX, int posY, int barValue, boolean left, int maxRowCount) {
        if (barValue <= 0 || maxRowCount <= 0) {
            return;
        }
        float rowCount = (float)barValue / (float)maxRowCount;
        ClientConfig config = (ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class);
        if (!config.rowCount.alwaysRenderRowCount && rowCount <= 1.0f) {
            return;
        }
        int numberValue = config.rowCount.countFullRowsOnly ? class_3532.method_15375((float)rowCount) : class_3532.method_15386((float)rowCount);
        int textColor = class_9848.method_61334((int)config.rowCount.rowCountColor.method_532());
        if (config.rowCount.forceFontRenderer) {
            class_327 font = class_310.method_1551().field_1772;
            Object text = String.valueOf(numberValue);
            if (config.rowCount.rowCountX) {
                text = (String)text + "x";
            }
            posX = left ? (posX -= font.method_1727((String)text)) : (posX += 5);
            GuiGraphicsHelper.drawInBatch8xOutline((class_332)guiGraphics, (class_327)font, (class_2561)class_2561.method_43470((String)text), (int)posX, (int)(posY + 1), (int)textColor, (int)class_9848.method_61334((int)0));
        } else {
            int[] numberDigitis = IntStream.iterate(numberValue, i -> i > 0, i -> i / 10).map(i -> i % 10).toArray();
            posX = left ? (posX -= config.rowCount.rowCountX ? 7 : 3) : (posX += 4 * numberDigitis.length);
            for (int i2 = 0; i2 < numberDigitis.length; ++i2) {
                RowCountRenderer.drawBorderedSprite(guiGraphics, 3, 5, posX - 4 * i2, posY + 2, 5 * numberDigitis[i2], 0, textColor);
            }
            if (config.rowCount.rowCountX) {
                RowCountRenderer.drawBorderedSprite(guiGraphics, 3, 5, posX + 4, posY + 2, 0, 7, textColor);
            }
        }
    }

    private static void drawBorderedSprite(class_332 guiGraphics, int width, int height, int posX, int posY, int textureX, int textureY, int textColor) {
        int backgroundColor = class_9848.method_61334((int)0);
        guiGraphics.method_25291(class_10799.field_56883, TINY_NUMBERS_LOCATION, posX - 1, posY, (float)textureX, (float)textureY, width, height, 256, 256, backgroundColor);
        guiGraphics.method_25291(class_10799.field_56883, TINY_NUMBERS_LOCATION, posX + 1, posY, (float)textureX, (float)textureY, width, height, 256, 256, backgroundColor);
        guiGraphics.method_25291(class_10799.field_56883, TINY_NUMBERS_LOCATION, posX, posY - 1, (float)textureX, (float)textureY, width, height, 256, 256, backgroundColor);
        guiGraphics.method_25291(class_10799.field_56883, TINY_NUMBERS_LOCATION, posX, posY + 1, (float)textureX, (float)textureY, width, height, 256, 256, backgroundColor);
        guiGraphics.method_25291(class_10799.field_56883, TINY_NUMBERS_LOCATION, posX, posY, (float)textureX, (float)textureY, width, height, 256, 256, textColor);
    }
}

