/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.dynamic;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.imb11.sounds.api.SoundDefinition;
import dev.imb11.sounds.api.config.TagPair;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import dev.imb11.sounds.dynamic.TagPairHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundsReloadListener
extends class_4080<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundsReloadListener.class);
    private static final Gson GSON = new Gson();

    public void reload(class_3300 manager) {
        SoundsReloadListener.handleDynamicSounds(manager);
        TagPairHelper.LOADED_TAG_PAIRS.clear();
        for (class_2960 id : manager.method_14488("sounds/blocks", path -> path.method_12832().endsWith(".json")).keySet()) {
            try {
                class_3298 resource = (class_3298)manager.method_14486(id).orElseThrow();
                InputStream inputStream = resource.method_14482();
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream));
                TagPair.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson(reader, JsonObject.class))).result().ifPresent(tagPair -> TagPairHelper.LOADED_TAG_PAIRS.put(id, (TagPair)tagPair.getFirst()));
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource json: " + id.toString(), (Throwable)e);
            }
        }
        TagPairHelper.buildCache();
    }

    private static void handleDynamicSounds(class_3300 manager) {
        DynamicSoundHelper.clearDefinitions();
        DynamicSoundHelper.loadDirectories.forEach((directory, codec) -> {
            ArrayList<?> resultList = DynamicSoundHelper.loadedDefinitions.get(directory);
            for (class_2960 id : manager.method_14488("sounds/" + directory, path -> path.method_12832().endsWith(".json")).keySet()) {
                try {
                    class_3298 resource = (class_3298)manager.method_14486(id).orElseThrow();
                    InputStream inputStream = resource.method_14482();
                    JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream));
                    SoundDefinition result = (SoundDefinition)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson(reader, JsonObject.class))).result().orElseThrow();
                    resultList.add(result);
                    inputStream.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while loading resource json: " + id.toString(), (Throwable)e);
                }
            }
            DynamicSoundHelper.loadedDefinitions.put((String)directory, resultList);
        });
        ArrayList items = new ArrayList();
        class_7923.field_41178.forEach(item -> items.add(item));
        ArrayList itemsWithLoadedDefinitions = new ArrayList();
        DynamicSoundHelper.loadedDefinitions.get("items").forEach(definition -> {
            SoundDefinition definitionCast = (SoundDefinition)definition;
            for (Either registryKeyTagKeyEither : definitionCast.getKeys().getInternalList()) {
                class_6862 tagKey;
                Optional entriesOpt;
                if (registryKeyTagKeyEither.left().isPresent()) {
                    class_5321 key = (class_5321)registryKeyTagKeyEither.left().get();
                    class_1792 entry = (class_1792)class_7923.field_41178.method_63535(key.method_29177());
                    itemsWithLoadedDefinitions.add(entry);
                    continue;
                }
                if (!registryKeyTagKeyEither.right().isPresent() || (entriesOpt = class_7923.field_41178.method_46733(tagKey = (class_6862)registryKeyTagKeyEither.right().get())).isEmpty()) continue;
                class_6885.class_6888 entries = (class_6885.class_6888)entriesOpt.get();
                for (class_6880 key : entries) {
                    Optional entry = class_7923.field_41178.method_46746((class_5321)key.method_40230().get());
                    itemsWithLoadedDefinitions.add((class_1792)((class_6880.class_6883)entry.get()).comp_349());
                }
            }
        });
    }

    protected Void prepare(class_3300 manager, class_3695 profiler) {
        profiler.method_15396("SoundsReloadListener");
        this.reload(manager);
        profiler.method_15407();
        return null;
    }

    protected void apply(Void prepared, class_3300 manager, class_3695 profiler) {
    }
}

