/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.mixin;

import dev.imb11.mru.LoaderUtils;
import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.api.config.TagPair;
import dev.imb11.sounds.api.event.SoundDefinitionReplacementEvent;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.WorldSoundsConfig;
import dev.imb11.sounds.dynamic.TagPairHelper;
import dev.imb11.sounds.util.BlockAccessor;
import net.minecraft.class_2404;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4970.class})
public abstract class BlockSoundMixin
implements BlockAccessor {
    @Unique
    @Nullable
    private TagPair sounds$associatedTagPair = null;
    @Unique
    private boolean sounds$hasFetched = false;

    @Override
    public void sounds$prepareTagPair(class_2960 value) {
        block5: {
            try {
                TagPair pair;
                if (class_310.method_1551() == null) {
                    return;
                }
                if (this instanceof class_2404) {
                    this.sounds$hasFetched = true;
                    return;
                }
                if (SoundsConfig.get(WorldSoundsConfig.class).disableBlocksEntirely || SoundsConfig.get(WorldSoundsConfig.class).ignoredBlocks.contains(value.toString())) {
                    return;
                }
                this.sounds$associatedTagPair = pair = TagPairHelper.get(value);
                this.sounds$hasFetched = true;
            }
            catch (Exception ignored) {
                if (!LoaderUtils.isDevelopmentEnvironment()) break block5;
                SoundsClient.LOGGER.warn("Early-load attempt at getting custom sound block group failed. Ignoring for now. {}", (Object)value.toString());
            }
        }
    }

    @Inject(method={"getSoundType"}, at={@At(value="HEAD")}, cancellable=true)
    public void $manageCustomSounds(class_2680 state, CallbackInfoReturnable<class_2498> cir) {
        class_2498 replacement;
        SoundDefinitionReplacementEvent.Response eventResponse;
        block8: {
            try {
                class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
                if (!this.sounds$hasFetched) {
                    this.sounds$prepareTagPair(id);
                }
                if (SoundsConfig.get(WorldSoundsConfig.class).disableBlocksEntirely || SoundsConfig.get(WorldSoundsConfig.class).ignoredBlocks.contains(id.toString())) {
                    return;
                }
            }
            catch (Exception ignored) {
                if (!LoaderUtils.isDevelopmentEnvironment()) break block8;
                SoundsClient.LOGGER.warn("Failed initial block fetch for blockstate {}", (Object)state.toString());
            }
        }
        class_2498 group = null;
        if (this.sounds$associatedTagPair != null) {
            group = this.sounds$associatedTagPair.getGroup();
        }
        if ((eventResponse = SoundDefinitionReplacementEvent.fire(group)).response() == SoundDefinitionReplacementEvent.ResponseType.OVERRIDE && (replacement = eventResponse.override()) != null) {
            cir.setReturnValue((Object)replacement);
        }
        if (eventResponse.response() == SoundDefinitionReplacementEvent.ResponseType.CANCEL) {
            return;
        }
        if (group != null) {
            cir.setReturnValue((Object)group);
        }
    }
}

