/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui.entries;

import com.demonwav.mcdev.annotations.Translatable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_11907;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;
import traben.tconfig.gui.entries.TConfigEntryValue;

public class TConfigEntryBoolean
extends TConfigEntryValue<Boolean> {
    private final BooleanButtonWidget widget;

    public TConfigEntryBoolean(@Translatable String translationKey, @Translatable @Nullable String tooltip, Supplier<Boolean> getter, Consumer<Boolean> setter, boolean defaultValue) {
        super(translationKey, tooltip, getter, setter, defaultValue);
        this.widget = new BooleanButtonWidget(0, 0, 20, 20, this.getText().getString(), getter.get(), this.getTooltip());
    }

    public TConfigEntryBoolean(@Translatable String translationKey, Supplier<Boolean> getter, Consumer<Boolean> setter, boolean defaultValue) {
        this(translationKey, (String)null, getter, setter, defaultValue);
    }

    public TConfigEntryBoolean setType(Type type) {
        this.widget.type = type;
        return this;
    }

    @Override
    protected Boolean getValueFromWidget() {
        return this.widget.value;
    }

    @Override
    public class_339 getWidget(int x, int y, int width, int height) {
        this.widget.method_55444(width, height, x, y);
        return this.widget;
    }

    @Override
    void setWidgetToDefaultValue() {
        this.widget.value = (Boolean)this.defaultValue;
        this.widget.updateMessage();
    }

    @Override
    void resetWidgetToInitialValue() {
        this.widget.value = (Boolean)this.getter.get();
        this.widget.updateMessage();
    }

    private class BooleanButtonWidget
    extends class_4185 {
        private final String title;
        private boolean value;
        private Type type;

        public BooleanButtonWidget(int x, int y, int width, int height, String text, boolean initialValue, class_7919 tooltip) {
            super(x, y, width, height, class_2561.method_30163((String)""), null, field_40754);
            this.type = Type.ON_OFF;
            this.value = initialValue;
            this.title = text + ": ";
            this.updateMessage();
            this.method_47400(tooltip);
        }

        private void updateMessage() {
            this.method_25355(class_2561.method_30163((String)(this.title + (this.value != (Boolean)TConfigEntryBoolean.this.getter.get() ? "\u00a7a" : "") + this.type.get(this.value))));
        }

        public void method_25306(class_11907 inputWithModifiers) {
            this.value = !this.value;
            this.updateMessage();
        }
    }

    public static enum Type {
        ON_OFF(class_5244.field_24332, class_5244.field_24333),
        YES_NO(class_5244.field_24336, class_5244.field_24337);

        private final String t;
        private final String f;

        private Type(class_2561 t, class_2561 f) {
            this.t = t.getString();
            this.f = f.getString();
        }

        public String get(boolean value) {
            return value ? this.t : this.f;
        }
    }
}

