/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.gravelminer;

import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.reflection.Comment;
import net.blay09.mods.balm.api.config.reflection.Config;
import net.blay09.mods.balm.api.config.reflection.NestedType;
import net.blay09.mods.gravelminer.GravelMinerActivation;
import net.blay09.mods.gravelminer.GravelMinerClientSetting;
import net.minecraft.class_2960;

@Config(value="gravelminer")
public class GravelMinerConfig {
    public Common common = new Common();
    public Client client = new Client();

    public static GravelMinerConfig getActive() {
        return (GravelMinerConfig)Balm.getConfig().getActiveConfig(GravelMinerConfig.class);
    }

    public static void initialize() {
        Balm.getConfig().registerConfig(GravelMinerConfig.class);
    }

    public static void setEnabled(boolean enabled) {
        Balm.getConfig().updateLocalConfig(GravelMinerConfig.class, config -> {
            config.client.isEnabled = enabled;
        });
    }

    public static GravelMinerClientSetting getClientSetting() {
        GravelMinerConfig config = GravelMinerConfig.getActive();
        if (config.client.isEnabled && config.client.activation == GravelMinerActivation.ALWAYS) {
            return GravelMinerClientSetting.ENABLED;
        }
        if (config.client.isEnabled && config.client.activation == GravelMinerActivation.WHEN_SNEAKING) {
            return GravelMinerClientSetting.ONLY_WHEN_SNEAKING;
        }
        if (config.client.isEnabled && config.client.activation == GravelMinerActivation.WHEN_NOT_SNEAKING) {
            return GravelMinerClientSetting.ONLY_WHEN_NOT_SNEAKING;
        }
        return GravelMinerClientSetting.DISABLED;
    }

    public static class Common {
        @NestedType(value=class_2960.class)
        @Comment(value="Blocks that will fall and break into items when hitting a non-solid block. Format: modid:name")
        public Set<class_2960> gravelBlocks = Set.of(class_2960.method_60656((String)"gravel"));
        @Comment(value="If set to true, the mod will trigger when mining gravel as well, instead of only when mining a non-gravel block below gravel.")
        public boolean triggerOnGravel = true;
        @Comment(value="If set to true, GravelMiner will only be active for users who install the mod on their clients (for use in servers).")
        public boolean isOptIn = true;
    }

    public static class Client {
        @Comment(value="Whether GravelMiner is currently enabled for this client (toggled via keybind)")
        public boolean isEnabled = true;
        @Comment(value="Defines when GravelMiner should activate. Either ALWAYS, WHEN_SNEAKING or WHEN_NOT_SNEAKING")
        public GravelMinerActivation activation = GravelMinerActivation.ALWAYS;
    }
}

