/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.simple;

import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11910;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.control.simple.GuiClientTextfield;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiSlider;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiSliderUpdateEvent;
import team.creative.creativecore.common.gui.parser.DoubleValueParser;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiClientSlider<T extends GuiSlider>
extends GuiClientControl<T>
implements GuiSlider.GuiSliderDist {
    protected double maxValue;
    protected double minValue;
    protected double value;
    private DoubleValueParser parser;
    protected boolean grabbedSlider;
    public int sliderSize = 4;
    protected GuiTextfield textfield;
    private GuiSlider minSlider;
    private GuiSlider maxSlider;

    public GuiClientSlider(T control) {
        super(control);
    }

    @Override
    public String getTextByValue() {
        return this.parser.parse(this.getValue(), this.getMaxValue());
    }

    @Override
    public String getTextfieldValue() {
        return this.getTextByValue();
    }

    @Override
    public double getPercentage() {
        return (this.value - this.minValue) / (this.maxValue - this.minValue);
    }

    @Override
    public void setParser(DoubleValueParser parser) {
        this.parser = parser;
    }

    @Override
    public void setSliderSize(int size) {
        this.sliderSize = size;
    }

    @Override
    public void setMinSlider(GuiSlider slider) {
        if (slider == this.control) {
            throw new IllegalArgumentException("slider argument is current slider");
        }
        this.minSlider = slider;
    }

    @Override
    public void setMaxSlider(GuiSlider slider) {
        if (slider == this.control) {
            throw new IllegalArgumentException("slider argument is current slider");
        }
        this.maxSlider = slider;
    }

    protected GuiClientTextfield textfield() {
        return (GuiClientTextfield)this.textfield.dist();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.grabbedSlider = false;
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean mouseClicked(double x, double y, class_11910 info) {
        if (info.comp_4801() == 0) {
            if (this.textfield != null) {
                return this.textfield().mouseClicked(x, y, info);
            }
            this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
            this.grabbedSlider = true;
            this.mouseMoved(x, y);
            return true;
        }
        if (info.comp_4801() == 1) {
            this.grabbedSlider = false;
            this.textfield = this.createTextfield();
            this.textfield().focus();
            this.textfield.setText(this.getTextfieldValue());
            this.textfield().setCursorPositionEnd();
            GuiControl.setParent(this.textfield, (IGuiParent)((Object)this.control));
            int width = this.rect.getWidth();
            this.textfield().rect.setWidth(width, width);
            this.textfield().rect.flowX();
            int height = this.rect.getHeight();
            this.textfield().rect.setHeight(height, height);
            this.textfield().rect.flowY();
            return true;
        }
        return false;
    }

    protected GuiTextfield createTextfield() {
        return new GuiTextfield((IGuiParent)((Object)this.control), ((GuiSlider)this.control).getNestedName() + ".text").setFloatOnly().setDim(this.rect.getContentWidth(), this.rect.getContentHeight());
    }

    @Override
    public void closeTextField() {
        double value = this.value;
        try {
            this.setValue(this.textfield.parseFloat(), true);
            this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
        }
        catch (NumberFormatException e) {
            this.setValue(value, true);
        }
        this.textfield = null;
    }

    @Override
    public boolean keyPressed(class_11908 key) {
        if (this.textfield != null) {
            if (key.comp_4795() == 257) {
                this.closeTextField();
                return true;
            }
            return this.textfield().keyPressed(key);
        }
        return super.keyPressed(key);
    }

    @Override
    public boolean charTyped(class_11905 event) {
        if (this.textfield != null) {
            return this.textfield().charTyped(event);
        }
        return super.charTyped(event);
    }

    @Override
    public void setBounds(double min, double max, boolean notify) {
        this.minValue = min;
        this.maxValue = max;
        this.setValue(Math.clamp(this.value, min, max), notify);
    }

    @Override
    public void setMaxValue(double maxValue) {
        if (this.maxValue != maxValue) {
            this.maxValue = Math.max(this.minValue, maxValue);
            this.setValue(this.value, true);
        }
    }

    @Override
    public void setMinValue(double minValue) {
        if (this.minValue != minValue) {
            this.minValue = Math.min(minValue, this.maxValue);
            this.setValue(this.value, true);
        }
    }

    @Override
    public void setValue(double value, boolean notify) {
        double valueBefore = this.value;
        this.value = Math.max(this.minValue, value);
        this.value = Math.min(this.maxValue, this.value);
        if (notify && valueBefore != this.value) {
            this.raiseEvent(new GuiSliderUpdateEvent((GuiSlider)this.control));
        }
        if (this.minSlider != null) {
            this.minSlider.setMaxValue(value);
        }
        if (this.maxSlider != null) {
            this.maxSlider.setMinValue(value);
        }
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.NESTED_NO_PADDING;
    }

    @Override
    public void mouseMoved(double x, double y) {
        if (this.grabbedSlider) {
            int width = this.rect.getContentWidth() - this.sliderSize;
            if (x < (double)this.getContentOffset()) {
                this.value = this.minValue;
            } else if (x > (double)((float)(this.getContentOffset() + width) + (float)this.sliderSize / 2.0f)) {
                this.value = this.maxValue;
            } else {
                int mouseOffsetX = (int)(x - (double)this.getContentOffset() - (double)(this.sliderSize / 2));
                this.value = (float)(this.minValue + (double)((float)((this.maxValue - this.minValue) * (double)((float)mouseOffsetX / (float)width))));
            }
            this.setValue(this.value, true);
        }
    }

    @Override
    public void looseFocus() {
        if (this.textfield != null) {
            this.closeTextField();
        }
        super.looseFocus();
    }

    @Override
    public void mouseReleased(double x, double y, class_11910 info) {
        if (this.grabbedSlider) {
            this.grabbedSlider = false;
        }
    }

    @Override
    protected void renderContent(class_332 graphics, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        double percent = this.getPercentage();
        int posX = (int)((double)(this.rect.getContentWidth() - this.sliderSize) * percent);
        GuiStyle style = this.getStyle();
        style.get(ControlFormatting.ControlStyleFace.CLICKABLE, false).render(graphics, posX, 0.0, this.sliderSize, this.rect.getContentHeight());
        if (this.textfield != null) {
            ((GuiClientControl)((Object)this.textfield.dist())).render(graphics, controlRect, controlRect, 1.0, mouseX, mouseY);
        } else {
            ((CreativeGuiGraphics)graphics).drawStringCentered(this.getTextByValue(), this.rect.getContentWidth(), this.rect.getContentHeight(), -1, true);
        }
    }

    @Override
    protected void renderContent(class_332 graphics, int mouseX, int mouseY) {
    }

    @Override
    public void flowX(int width, int preferred) {
        if (this.textfield != null) {
            this.textfield().flowX(width, preferred);
        }
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        if (this.textfield != null) {
            this.textfield().flowY(width, height, preferred);
        }
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 40;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 10;
    }
}

