/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.simple;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.class_3532;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiButtonHold;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiCounterDecimal
extends GuiParent {
    public static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    public double min;
    public double max;
    public final GuiParent buttons;
    public GuiTextfield textfield;
    public double stepAmount;
    public final ControlFormatting buttonsFormatting;

    public GuiCounterDecimal(IGuiParent parent, String name, double value) {
        this(parent, name, value, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public GuiCounterDecimal(IGuiParent parent, String name, double value, double min, double max) {
        this(parent, name, value, min, max, ControlFormatting.TRANSPARENT);
    }

    public GuiCounterDecimal(IGuiParent parent, String name, double value, double min, double max, ControlFormatting buttonsFormatting) {
        super(parent, name);
        this.min = min;
        this.max = max;
        this.stepAmount = 1.0;
        this.setSpacing(1);
        this.setFlow(GuiFlow.STACK_X);
        this.textfield = new GuiTextfield(this, "value", "" + class_3532.method_15350((double)value, (double)min, (double)max)).setDim(30, 10).setFloatOnly();
        this.buttons = new GuiParent((IGuiParent)this, GuiFlow.STACK_Y);
        this.buttons.setSpacing(0);
        this.buttonsFormatting = buttonsFormatting;
        this.createButtons();
        this.add(this.textfield.setExpandableX());
        this.add((GuiControl)this.buttons);
    }

    protected void createButtons() {
        this.buttons.add(new GuiButtonHold(this, "+", x -> this.stepUp()).setHoverEffect(true).setTranslate("gui.plus").setFormatting(this.buttonsFormatting).setDim(6, 3));
        this.buttons.add(new GuiButtonHold(this, "-", x -> this.stepDown()).setHoverEffect(true).setTranslate("gui.minus").setFormatting(this.buttonsFormatting).setDim(6, 3));
    }

    @Override
    public GuiCounterDecimal setSpacing(int spacing) {
        return (GuiCounterDecimal)super.setSpacing(spacing);
    }

    @Override
    public GuiCounterDecimal add(GuiControl control) {
        return (GuiCounterDecimal)super.add(control);
    }

    @Override
    public boolean isExpandableX() {
        if (this.dist() != null) {
            return this.dist().isExpandableX();
        }
        return false;
    }

    public GuiButtonHold getPlusButton() {
        return (GuiButtonHold)this.buttons.get("+");
    }

    public GuiButtonHold getMinusButton() {
        return (GuiButtonHold)this.buttons.get("-");
    }

    public GuiCounterDecimal setStep(double amount) {
        this.stepAmount = amount;
        return this;
    }

    public DecimalFormat getFormat() {
        return FORMAT;
    }

    public void resetTextfield() {
        this.textfield.setCursorPositionZero();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void raiseEvent(GuiEvent event) {
        if (event instanceof GuiControlChangedEvent) {
            GuiControlChangedEvent controlEvent = (GuiControlChangedEvent)event;
            if (controlEvent.control.is("value")) {
                super.raiseEvent(new GuiControlChangedEvent<GuiCounterDecimal>(this));
                return;
            }
        }
        super.raiseEvent(event);
    }

    public void stepUp() {
        this.setValue(this.getValue() + this.stepAmount);
    }

    public void stepDown() {
        this.setValue(this.getValue() - this.stepAmount);
    }

    public double getValue() {
        return class_3532.method_15350((double)this.textfield.parseDouble(), (double)this.min, (double)this.max);
    }

    public void setValue(double value) {
        this.textfield.setText(this.getFormat().format(class_3532.method_15350((double)value, (double)this.min, (double)this.max)));
        this.raiseEvent(new GuiControlChangedEvent<GuiCounterDecimal>(this));
    }

    static {
        FORMAT.setRoundingMode(RoundingMode.HALF_UP);
    }
}

