/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.services.modrinth;

import com.google.gson.reflect.TypeToken;
import dev.dediamondpro.resourcify.Constants;
import dev.dediamondpro.resourcify.libs.minemark.elementa.style.MarkdownStyle;
import dev.dediamondpro.resourcify.services.IProject;
import dev.dediamondpro.resourcify.services.ISearchData;
import dev.dediamondpro.resourcify.services.IService;
import dev.dediamondpro.resourcify.services.IVersion;
import dev.dediamondpro.resourcify.services.ProjectType;
import dev.dediamondpro.resourcify.services.ads.IAdProvider;
import dev.dediamondpro.resourcify.services.modrinth.FullModrinthProject;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthCategory;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthMinecraftVersion;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthSearchData;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthUpdateFormat;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthVersion;
import dev.dediamondpro.resourcify.util.JsonUtil;
import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import dev.dediamondpro.resourcify.util.Utils;
import dev.dediamondpro.resourcify.util.UtilsKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJM\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J3\u0010\u0016\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00190\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0003J5\u0010\u001e\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00190\u00190\u00182\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b#\u0010\u0003J\u0017\u0010&\u001a\u00020\t2\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b&\u0010'J!\u0010)\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010\u00182\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b)\u0010*J)\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020(0\u00192\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016\u00a2\u0006\u0004\b,\u0010-J9\u00101\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020.\u0012\u0006\u0012\u0004\u0018\u0001000\u00190\u00182\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b1\u00102J\u0015\u00103\u001a\u0004\u0018\u00010\u0004*\u00020\u0007H\u0002\u00a2\u0006\u0004\b3\u00104J\u001b\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0019H\u0016\u00a2\u0006\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b7\u00108R$\u0010\u000f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002090\u000e\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010:R$\u0010\u0010\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0\u000e\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010:R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=\u00a8\u0006>"}, d2={"Ldev/dediamondpro/resourcify/services/modrinth/ModrinthService;", "Ldev/dediamondpro/resourcify/services/IService;", "<init>", "()V", "", "getName", "()Ljava/lang/String;", "Ldev/dediamondpro/resourcify/services/ProjectType;", "type", "", "isProjectTypeSupported", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Z", "query", "sortBy", "", "minecraftVersions", "categories", "", "offset", "Ldev/dediamondpro/resourcify/services/ISearchData;", "search", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;ILdev/dediamondpro/resourcify/services/ProjectType;)Ldev/dediamondpro/resourcify/services/ISearchData;", "buildFacets", "(Ldev/dediamondpro/resourcify/services/ProjectType;Ljava/util/List;Ljava/util/List;)Ljava/lang/String;", "Ljava/util/concurrent/CompletableFuture;", "", "getMinecraftVersions", "()Ljava/util/concurrent/CompletableFuture;", "", "fetchMinecraftVersions", "getCategories", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/util/concurrent/CompletableFuture;", "category", "localizeCategory", "(Ljava/lang/String;)Ljava/lang/String;", "fetchCategories", "Ljava/net/URI;", "uri", "canFetchProjectUrl", "(Ljava/net/URI;)Z", "Ldev/dediamondpro/resourcify/services/IProject;", "fetchProjectFromUrl", "(Ljava/net/URI;)Ljava/util/concurrent/CompletableFuture;", "ids", "getProjectsFromIds", "(Ljava/util/List;)Ljava/util/Map;", "Ljava/io/File;", "files", "Ldev/dediamondpro/resourcify/services/IVersion;", "getUpdates", "(Ljava/util/List;Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/util/concurrent/CompletableFuture;", "getProjectType", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/lang/String;", "getSortOptions", "()Ljava/util/Map;", "API", "Ljava/lang/String;", "Ldev/dediamondpro/resourcify/services/modrinth/ModrinthMinecraftVersion;", "Ljava/util/concurrent/CompletableFuture;", "Ldev/dediamondpro/resourcify/services/modrinth/ModrinthCategory;", "knownTypes", "Ljava/util/List;", "Resourcify (1.21.9-fabric)-1.7.4"})
@SourceDebugExtension(value={"SMAP\nModrinthService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModrinthService.kt\ndev/dediamondpro/resourcify/services/modrinth/ModrinthService\n+ 2 NetworkUtil.kt\ndev/dediamondpro/resourcify/util/NetworkUtilKt\n+ 3 JsonUtil.kt\ndev/dediamondpro/resourcify/util/JsonUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,189:1\n178#2,5:190\n178#2,5:197\n178#2,5:220\n178#2,5:255\n178#2,5:263\n259#2,5:283\n237#2,4:288\n241#2,3:294\n244#2,2:299\n246#2,11:302\n35#3,2:195\n35#3,2:202\n35#3,2:225\n35#3,2:260\n35#3,2:268\n40#3,2:292\n35#3,2:313\n1202#4,2:204\n1230#4,2:206\n230#4,2:208\n1233#4:210\n774#4:211\n865#4,2:212\n1187#4,2:214\n1261#4,4:216\n774#4:227\n865#4,2:228\n1485#4:230\n1510#4,3:231\n1513#4,3:241\n1246#4,2:246\n1187#4,2:248\n1261#4,4:250\n1249#4:254\n1053#4:262\n1611#4,9:270\n1863#4:279\n1864#4:281\n1620#4:282\n774#4:319\n865#4,2:320\n381#5,7:234\n462#5:244\n412#5:245\n1#6:280\n1#6:301\n216#7,2:297\n126#7:315\n153#7,3:316\n*S KotlinDebug\n*F\n+ 1 ModrinthService.kt\ndev/dediamondpro/resourcify/services/modrinth/ModrinthService\n*L\n49#1:190,5\n145#1:197,5\n87#1:220,5\n113#1:255,5\n139#1:263,5\n164#1:283,5\n164#1:288,4\n164#1:294,3\n164#1:299,2\n164#1:302,11\n49#1:195,2\n145#1:202,2\n87#1:225,2\n113#1:260,2\n139#1:268,2\n164#1:292,2\n164#1:313,2\n146#1:204,2\n146#1:206,2\n146#1:208,2\n146#1:210\n78#1:211\n78#1:212,2\n79#1:214,2\n79#1:216,4\n95#1:227\n95#1:228,2\n96#1:230\n96#1:231,3\n96#1:241,3\n97#1:246,2\n98#1:248,2\n98#1:250,4\n97#1:254\n116#1:262\n151#1:270,9\n151#1:279\n151#1:281\n151#1:282\n170#1:319\n170#1:320,2\n96#1:234,7\n97#1:244\n97#1:245\n151#1:280\n164#1:301\n164#1:297,2\n168#1:315\n168#1:316,3\n*E\n"})
public final class ModrinthService
implements IService {
    @NotNull
    public static final ModrinthService INSTANCE = new ModrinthService();
    @NotNull
    public static final String API = "https://api.modrinth.com/v2";
    @Nullable
    private static CompletableFuture<List<ModrinthMinecraftVersion>> minecraftVersions;
    @Nullable
    private static CompletableFuture<List<ModrinthCategory>> categories;
    @NotNull
    private static final List<String> knownTypes;

    private ModrinthService() {
    }

    @Override
    @NotNull
    public String getName() {
        return "Modrinth";
    }

    @Override
    public boolean isProjectTypeSupported(@NotNull ProjectType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return this.getProjectType(type2) != null;
    }

    @Override
    @Nullable
    public ISearchData search(@NotNull String query, @NotNull String sortBy2, @NotNull List<String> minecraftVersions, @NotNull List<String> categories, int offset2, @NotNull ProjectType type2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortBy2, (String)"sortBy");
        Intrinsics.checkNotNullParameter(minecraftVersions, (String)"minecraftVersions");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        URI uRI = new URIBuilder("https://api.modrinth.com/v2/search").setParameter("query", query).setParameter("facets", this.buildFacets(type2, minecraftVersions, categories)).setParameter("limit", "20").setParameter("offset", String.valueOf(offset2)).setParameter("index", sortBy2).build();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
        URI $this$getJson_u24default$iv = uRI;
        boolean useCache$iv = true;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString($this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<ModrinthSearchData>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        return (ISearchData)object;
    }

    private final String buildFacets(ProjectType type2, List<String> minecraftVersions, List<String> categories) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildFacets_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildFacets_u24lambda_u242.append("[");
        $this$buildFacets_u24lambda_u242.append((String)(switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> "[\"project_type:datapack\"]";
            case 2 -> "[\"project_type:shader\"],[\"categories=iris\"]";
            case 3 -> "[\"project_type:shader\"],[\"categories=optifine\"]";
            default -> "[\"project_type:" + INSTANCE.getProjectType(type2) + "\"]";
        }));
        if (!((Collection)categories).isEmpty()) {
            $this$buildFacets_u24lambda_u242.append(",");
            $this$buildFacets_u24lambda_u242.append(CollectionsKt.joinToString$default((Iterable)categories, (CharSequence)",", null, null, (int)0, null, ModrinthService::buildFacets$lambda$2$lambda$0, (int)30, null));
        }
        if (!((Collection)minecraftVersions).isEmpty()) {
            $this$buildFacets_u24lambda_u242.append(",[");
            $this$buildFacets_u24lambda_u242.append(CollectionsKt.joinToString$default((Iterable)minecraftVersions, (CharSequence)",", null, null, (int)0, null, ModrinthService::buildFacets$lambda$2$lambda$1, (int)30, null));
            $this$buildFacets_u24lambda_u242.append("]");
        }
        $this$buildFacets_u24lambda_u242.append("]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public CompletableFuture<Map<String, String>> getMinecraftVersions() {
        this.fetchMinecraftVersions();
        CompletionStage<Object> completionStage = minecraftVersions;
        if (completionStage == null || (completionStage = completionStage.thenApply(arg_0 -> ModrinthService.getMinecraftVersions$lambda$6(ModrinthService::getMinecraftVersions$lambda$5, arg_0))) == null) {
            completionStage = MultiThreadingKt.supply(ModrinthService::getMinecraftVersions$lambda$7);
        }
        return completionStage;
    }

    private final void fetchMinecraftVersions() {
        if (minecraftVersions != null) {
            CompletableFuture<List<ModrinthMinecraftVersion>> completableFuture = minecraftVersions;
            boolean bl = completableFuture != null ? !completableFuture.isCompletedExceptionally() : false;
            if (bl) {
                return;
            }
        }
        minecraftVersions = MultiThreadingKt.supplyAsync(ModrinthService::fetchMinecraftVersions$lambda$8);
    }

    @Override
    @NotNull
    public CompletableFuture<Map<String, Map<String, String>>> getCategories(@NotNull ProjectType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.fetchCategories();
        CompletionStage<Object> completionStage = categories;
        if (completionStage == null || (completionStage = completionStage.thenApply(arg_0 -> ModrinthService.getCategories$lambda$14(arg_0 -> ModrinthService.getCategories$lambda$13(type2, arg_0), arg_0))) == null) {
            completionStage = MultiThreadingKt.supply(ModrinthService::getCategories$lambda$15);
        }
        return completionStage;
    }

    private final String localizeCategory(String category) {
        String string = category.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return UtilsKt.localizeOrDefaultExtension("resourcify.categories." + StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null), UtilsKt.capitalizeAll(category), new Object[0]);
    }

    private final void fetchCategories() {
        if (categories != null) {
            CompletableFuture<List<ModrinthCategory>> completableFuture = categories;
            boolean bl = completableFuture != null ? !completableFuture.isCompletedExceptionally() : false;
            if (bl) {
                return;
            }
        }
        categories = MultiThreadingKt.supplyAsync(ModrinthService::fetchCategories$lambda$16).thenApply(arg_0 -> ModrinthService.fetchCategories$lambda$19(ModrinthService::fetchCategories$lambda$18, arg_0));
    }

    @Override
    public boolean canFetchProjectUrl(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)uri.getHost(), (Object)"modrinth.com");
    }

    @Override
    @Nullable
    public CompletableFuture<IProject> fetchProjectFromUrl(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String[] stringArray = new String[]{"/"};
        List path = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)string, (CharSequence)"/"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (path.size() < 2) {
            return null;
        }
        if (!knownTypes.contains(path.get(0))) {
            return null;
        }
        URI uRI = NetworkUtilKt.toURIOrNull("https://api.modrinth.com/v2/project/" + path.get(1));
        if (uRI == null) {
            return null;
        }
        URI url = uRI;
        return MultiThreadingKt.supplyAsync(() -> ModrinthService.fetchProjectFromUrl$lambda$20(url));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, IProject> getProjectsFromIds(@NotNull List<String> ids) {
        void $this$associateByTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        String idString = CollectionsKt.joinToString$default((Iterable)ids, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, ModrinthService::getProjectsFromIds$lambda$21, (int)24, null);
        URI uRI = new URIBuilder("https://api.modrinth.com/v2/projects").setParameter("ids", idString).build();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
        URI $this$getJson_u24default$iv = uRI;
        boolean useCache$iv = true;
        int attempts$iv = 3;
        Object headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString($this$getJson_u24default$iv, useCache$iv, attempts$iv, (Map<String, String>)headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<List<? extends FullModrinthProject>>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        Intrinsics.checkNotNull(object);
        Iterable $this$associateBy$iv = (Iterable)object;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        headers$iv = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Object element$iv2;
            Map map2;
            block4: {
                FullModrinthProject fullModrinthProject = (FullModrinthProject)element$iv$iv;
                map2 = destination$iv$iv;
                boolean bl = false;
                Iterable $this$first$iv = ids;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    void project;
                    String it = (String)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)project.getId(), (Object)it)) continue;
                    break block4;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            map2.put((String)element$iv2, element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Override
    @NotNull
    public CompletableFuture<Map<File, IVersion>> getUpdates(@NotNull List<? extends File> files, @NotNull ProjectType type2) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return MultiThreadingKt.supplyAsync(() -> ModrinthService.getUpdates$lambda$27(files, type2));
    }

    private final String getProjectType(ProjectType $this$getProjectType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getProjectType.ordinal()]) {
            case 4 -> "resourcepack";
            case 1 -> "mod";
            case 2 -> "shader";
            case 3 -> "shader";
            default -> null;
        };
    }

    @Override
    @NotNull
    public Map<String, String> getSortOptions() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"relevance", (Object)"resourcify.browse.sort.relevance"), TuplesKt.to((Object)"downloads", (Object)"resourcify.browse.sort.downloads"), TuplesKt.to((Object)"follows", (Object)"resourcify.browse.sort.follows"), TuplesKt.to((Object)"newest", (Object)"resourcify.browse.sort.newest"), TuplesKt.to((Object)"updated", (Object)"resourcify.browse.sort.updated")};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public boolean canSelectMultipleMinecraftVersions() {
        return IService.DefaultImpls.canSelectMultipleMinecraftVersions(this);
    }

    @Override
    @NotNull
    public IAdProvider getAdProvider() {
        return IService.DefaultImpls.getAdProvider(this);
    }

    @Override
    @NotNull
    public MarkdownStyle getMarkdownStyle() {
        return IService.DefaultImpls.getMarkdownStyle(this);
    }

    private static final CharSequence buildFacets$lambda$2$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "[\"categories:'" + it + "'\"]";
    }

    private static final CharSequence buildFacets$lambda$2$lambda$1(String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return "\"versions:" + version + "\"";
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getMinecraftVersions$lambda$5(List it) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$filter$iv = it;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModrinthMinecraftVersion version = (ModrinthMinecraftVersion)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)version.getVersionType(), (Object)"release")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            ModrinthMinecraftVersion version = (ModrinthMinecraftVersion)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)version.getVersion(), (Object)version.getVersion());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private static final Map getMinecraftVersions$lambda$6(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map getMinecraftVersions$lambda$7() {
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchMinecraftVersions$lambda$8() {
        Object object;
        void $this$getJson_u24default$iv;
        URI uRI = NetworkUtilKt.toURI("https://api.modrinth.com/v2/tag/game_version");
        boolean useCache$iv = false;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString((URI)$this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<List<? extends ModrinthMinecraftVersion>>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        List list = (List)object;
        if (list == null) {
            throw new IllegalStateException("Failed to fetch Minecraft versions.".toString());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getCategories$lambda$13(ProjectType $type, List it) {
        void $this$mapValuesTo$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        ModrinthCategory category;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$filter$iv = it;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            category = (ModrinthCategory)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)category.getProjectType(), (Object)INSTANCE.getProjectType($type))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            category = (ModrinthCategory)element$iv$iv;
            boolean bl = false;
            key$iv$iv = INSTANCE.localizeCategory(category.getHeader());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$associateTo$iv$iv;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object2 = object;
            boolean bl3 = false;
            List categories = (List)entry.getValue();
            Iterable $this$associate$iv = categories;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable2 = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                ModrinthCategory category2 = (ModrinthCategory)element$iv$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to((Object)category2.getName(), (Object)INSTANCE.localizeCategory(category2.getName()));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map map3 = destination$iv$iv2;
            object2.put(k, map3);
        }
        return destination$iv$iv;
    }

    private static final Map getCategories$lambda$14(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map getCategories$lambda$15() {
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchCategories$lambda$16() {
        Object object;
        void $this$getJson_u24default$iv;
        URI uRI = NetworkUtilKt.toURI("https://api.modrinth.com/v2/tag/category");
        boolean useCache$iv = false;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString((URI)$this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<List<? extends ModrinthCategory>>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        List list = (List)object;
        if (list == null) {
            throw new IllegalStateException("Failed to fetch categories.".toString());
        }
        return list;
    }

    private static final List fetchCategories$lambda$18(List it) {
        List list = it;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Object object;
                String string;
                Regex regex;
                Object object2;
                ModrinthCategory category = (ModrinthCategory)a;
                boolean bl = false;
                String string2 = category.getHeader();
                CharSequence charSequence = category.getName();
                if (!new Regex("^[0-9].*").matches(charSequence)) {
                    object2 = "\uffff" + category.getName();
                } else {
                    charSequence = category.getName();
                    regex = new Regex("[^0-9]");
                    string = "";
                    object2 = Character.valueOf((char)Integer.parseInt(regex.replace(charSequence, string)));
                }
                category = (ModrinthCategory)b;
                Comparable comparable = (Comparable)((Object)(string2 + object2));
                bl = false;
                String string3 = category.getHeader();
                charSequence = category.getName();
                if (!new Regex("^[0-9].*").matches(charSequence)) {
                    object = "\uffff" + category.getName();
                } else {
                    charSequence = category.getName();
                    regex = new Regex("[^0-9]");
                    string = "";
                    object = Character.valueOf((char)Integer.parseInt(regex.replace(charSequence, string)));
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)(string3 + object))));
            }
        });
    }

    private static final List fetchCategories$lambda$19(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final IProject fetchProjectFromUrl$lambda$20(URI $url) {
        Object object;
        URI $this$getJson_u24default$iv = $url;
        boolean useCache$iv = true;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString($this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<FullModrinthProject>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        return (IProject)object;
    }

    private static final CharSequence getProjectsFromIds$lambda$21(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static final Map getUpdates$lambda$27(List $files, ProjectType $type) {
        block32: {
            $this$mapNotNull$iv = $files;
            $i$f$mapNotNull = false;
            var5_5 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var10_16 = $this$forEach$iv$iv$iv.iterator();
            while (var10_16.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var10_16.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = (File)element$iv$iv;
                $i$a$-mapNotNull-ModrinthService$getUpdates$1$hashes$1 = false;
                v0 = hash = Utils.INSTANCE.getSha1(it);
                if ((v0 == null ? null : TuplesKt.to((Object)v0, (Object)it)) == null) continue;
                it$iv$iv = it$iv$iv;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            hashes = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            switch (WhenMappings.$EnumSwitchMapping$0[$type.ordinal()]) {
                case 4: {
                    v1 = "minecraft";
                    break;
                }
                case 2: {
                    v1 = "iris";
                    break;
                }
                case 3: {
                    v1 = "optifine";
                    break;
                }
                case 1: {
                    v1 = "datapack";
                    break;
                }
                default: {
                    throw new IllegalStateException(($type + " is not supported in updates").toString());
                }
            }
            loader = v1;
            destination$iv$iv = NetworkUtilKt.toURI("https://api.modrinth.com/v2/version_files/update");
            $i$f$mapNotNullTo = CollectionsKt.listOf((Object)loader);
            $this$forEach$iv$iv$iv = CollectionsKt.toList((Iterable)hashes.keySet());
            $i$f$mapNotNullTo = new ModrinthUpdateFormat($this$forEach$iv$iv$iv, (List)$i$f$mapNotNullTo, null, null, 12, null);
            attempts$iv = 3;
            headers$iv = MapsKt.emptyMap();
            $i$f$postAndGetJson = false;
            $this$postAndGetString$iv$iv = $this$postAndGetJson_u24default$iv;
            $i$f$postAndGetString = false;
            for (i$iv$iv = 0; i$iv$iv < attempts$iv; ++i$iv$iv) {
                block31: {
                    try {
                        v2 = $this$postAndGetString$iv$iv.toURL();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toURL(...)");
                        con$iv$iv = NetworkUtilKt.setupConnection(v2);
                        $this$toJson$iv$iv$iv = data$iv;
                        $i$f$toJson = false;
                        type$iv$iv$iv = new TypeToken<ModrinthUpdateFormat>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)JsonUtil.INSTANCE.getGson().toJson((Object)$this$toJson$iv$iv$iv, (Type)type$iv$iv$iv), (String)"toJson(...)");
                        con$iv$iv.setRequestProperty("Content-Type", "application/json");
                        con$iv$iv.setRequestProperty("Content-Length", String.valueOf(output$iv$iv.length()));
                        $this$forEach$iv$iv$iv = headers$iv;
                        $i$f$forEach = false;
                        for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                            var20_43 = element$iv$iv$iv;
                            $i$a$-forEach-NetworkUtilKt$postAndGetString$1$iv$iv = false;
                            key$iv$iv = (String)var20_43.getKey();
                            value$iv$iv = (String)var20_43.getValue();
                            con$iv$iv.setRequestProperty(key$iv$iv, value$iv$iv);
                        }
                        con$iv$iv.setDoOutput(true);
                        v3 = con$iv$iv.getOutputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getOutputStream(...)");
                        $this$forEach$iv$iv$iv = v3;
                        var16_32 = Charsets.UTF_8;
                        type$iv$iv$iv = new OutputStreamWriter((OutputStream)$this$forEach$iv$iv$iv, (Charset)var16_32);
                        element$iv$iv$iv = 8192;
                        $this$forEach$iv$iv$iv = type$iv$iv$iv instanceof BufferedWriter != false ? (BufferedWriter)type$iv$iv$iv : new BufferedWriter((Writer)type$iv$iv$iv, element$iv$iv$iv);
                        var16_32 = null;
                        try {
                            it$iv$iv = (BufferedWriter)$this$forEach$iv$iv$iv;
                            $i$a$-use-NetworkUtilKt$postAndGetString$2$iv$iv = false;
                            it$iv$iv.write(output$iv$iv);
                            var17_34 = Unit.INSTANCE;
                        }
                        catch (Throwable var17_35) {
                            var16_32 = var17_35;
                            throw var17_35;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)$this$forEach$iv$iv$iv, (Throwable)var16_32);
                        }
                        v4 = NetworkUtilKt.getEncodedInputStream(con$iv$iv);
                        if (v4 != null) {
                            var19_42 /* !! */  = v4;
                            var20_43 = Charsets.UTF_8;
                            $i$a$-forEach-NetworkUtilKt$postAndGetString$1$iv$iv = new InputStreamReader(var19_42 /* !! */ , (Charset)var20_43);
                            key$iv$iv = 8192;
                            var19_42 /* !! */  = $i$a$-forEach-NetworkUtilKt$postAndGetString$1$iv$iv instanceof BufferedReader != false ? (BufferedReader)$i$a$-forEach-NetworkUtilKt$postAndGetString$1$iv$iv : new BufferedReader($i$a$-forEach-NetworkUtilKt$postAndGetString$1$iv$iv, key$iv$iv);
                            var20_43 = null;
                            try {
                                it$iv$iv = (BufferedReader)var19_42 /* !! */ ;
                                $i$a$-use-NetworkUtilKt$postAndGetString$result$1$iv$iv = false;
                                var21_45 = TextStreamsKt.readText((Reader)it$iv$iv);
                                v5 = var21_45;
                            }
                            catch (Throwable var21_46) {
                                var20_43 = var21_46;
                                throw var21_46;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var19_42 /* !! */ , (Throwable)var20_43);
                            }
                        } else {
                            v5 = result$iv$iv = null;
                        }
                        if (result$iv$iv == null) break block31;
                        v6 = result$iv$iv;
                        break block32;
                    }
                    catch (Exception e$iv$iv) {
                        Constants.INSTANCE.getLOGGER().error("Failed to post and get string from \"" + (URI)$this$postAndGetString$iv$iv + "\"", (Throwable)e$iv$iv);
                    }
                }
                Thread.sleep(250L);
            }
            v6 = null;
        }
        if (v6 != null) {
            $this$fromJson$iv$iv = v6;
            $i$f$fromJson = false;
            type$iv$iv = new TypeToken<Map<String, ? extends ModrinthVersion>>(){}.getType();
            v7 = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            v7 = null;
        }
        v8 = (Map)v7;
        if (v8 == null) {
            throw new IllegalStateException("Failed to fetch updates".toString());
        }
        data = v8;
        $this$map$iv = data;
        $i$f$map = false;
        data$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>($this$map$iv.size());
        $i$f$mapTo = false;
        var10_18 = $this$mapTo$iv$iv.entrySet().iterator();
        while (var10_18.hasNext()) {
            $i$f$fromJson = item$iv$iv = var10_18.next();
            var24_51 = destination$iv$iv;
            $i$a$-map-ModrinthService$getUpdates$1$1 = false;
            v9 = hashes.get(it.getKey());
            Intrinsics.checkNotNull(v9);
            var24_51.add(TuplesKt.to(v9, Intrinsics.areEqual(it.getKey(), (Object)((ModrinthVersion)it.getValue()).getSha1()) != false ? null : (ModrinthVersion)it.getValue()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            $i$a$-filter-ModrinthService$getUpdates$1$2 = false;
            if (it.getSecond() == null) ** GOTO lbl-1000
            v10 = it.getSecond();
            Intrinsics.checkNotNull((Object)v10);
            if (!hashes.containsKey(((ModrinthVersion)v10).getSha1())) {
                v11 = true;
            } else lbl-1000:
            // 2 sources

            {
                v11 = false;
            }
            if (!v11) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    static {
        Object[] objectArray = new String[]{"resourcepack", "datapack", "shaders", "mod", "modpack", "plugin"};
        knownTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectType.values().length];
            try {
                nArray[ProjectType.DATA_PACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.IRIS_SHADER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.OPTIFINE_SHADER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.RESOURCE_PACK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

