/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ITooltip;
import snownee.jade.api.ui.BoxElement;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.MessageType;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.ui.HorizontalLineElement;

public class ClientViewGroup<T> {
    public final List<T> views;
    @Nullable
    public class_2561 title;
    public MessageType messageType = MessageType.NORMAL;
    public float boxProgress;
    @Nullable
    public class_2487 extraData;

    public ClientViewGroup(List<T> views) {
        this.views = views;
    }

    public static <IN, OUT> List<ClientViewGroup<OUT>> map(List<ViewGroup<IN>> groups, Function<IN, OUT> itemFactory, @Nullable BiConsumer<ViewGroup<IN>, ClientViewGroup<OUT>> clientGroupDecorator) {
        return groups.stream().map($ -> {
            ClientViewGroup<Object> group = new ClientViewGroup<Object>($.views.stream().map(itemFactory).filter(Objects::nonNull).toList());
            class_2487 data = $.extraData;
            if (data != null) {
                group.boxProgress = data.method_66563("Progress", 0.0f);
                group.messageType = data.method_10558("MessageType").map(MessageType::parse).orElse(MessageType.NORMAL);
            }
            if (clientGroupDecorator != null) {
                clientGroupDecorator.accept((ViewGroup)$, (ClientViewGroup)group);
            }
            group.extraData = data;
            return group;
        }).toList();
    }

    public static <T> void tooltip(ITooltip tooltip, List<ClientViewGroup<T>> groups, boolean renderGroup, BiConsumer<ITooltip, ClientViewGroup<T>> consumer) {
        for (ClientViewGroup<T> group : groups) {
            ITooltip theTooltip = renderGroup ? JadeUI.tooltip() : tooltip;
            consumer.accept(theTooltip, group);
            if (!renderGroup) continue;
            BoxStyle boxStyle = BoxStyle.viewGroup().clone();
            BoxElement box = JadeUI.box(theTooltip, boxStyle);
            tooltip.add(box.flexGrow(1));
        }
    }

    public boolean shouldRenderGroup() {
        return this.title != null || this.boxProgress > 0.0f;
    }

    public void renderHeader(ITooltip tooltip) {
        if (this.title != null) {
            tooltip.add(new HorizontalLineElement());
            tooltip.append(JadeUI.text(this.title).scale(0.5f));
            tooltip.append(new HorizontalLineElement().flexGrow(1));
        }
    }
}

