/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8015;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8028;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.WailaConfigScreen;
import snownee.jade.gui.config.KeybindOptionButton;
import snownee.jade.gui.config.OptionsNav;
import snownee.jade.gui.config.value.CycleOptionValue;
import snownee.jade.gui.config.value.InputOptionValue;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.gui.config.value.SliderOptionValue;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.SmoothChasingValue;

public class OptionsList
extends class_4265<Entry> {
    public static final class_2561 OPTION_ON = class_5244.field_24332.method_27661().method_27694(style -> style.method_36139(-4589878));
    public static final class_2561 OPTION_OFF = class_5244.field_24333.method_27661().method_27694(style -> style.method_36139(-30080));
    public final Set<Entry> forcePreview = Sets.newIdentityHashSet();
    protected final List<Entry> entries = Lists.newArrayList();
    private final Runnable diskWriter;
    public Title currentTitle;
    public OptionValue<?> invalidEntry;
    public class_304 selectedKey;
    private BaseOptionsScreen owner;
    private final SmoothChasingValue smoothScroll;
    private Entry defaultParent;

    public OptionsList(BaseOptionsScreen owner, class_310 client, int x, int y, int width, int height, int entryHeight, Runnable diskWriter) {
        super(client, width, height, y, entryHeight);
        this.method_46421(x);
        this.owner = owner;
        this.diskWriter = diskWriter;
        this.smoothScroll = new SmoothChasingValue().withSpeed(0.6f);
    }

    public OptionsList(BaseOptionsScreen owner, class_310 client, int x, int y, int width, int height, int entryHeight) {
        this(owner, client, x, y, width, height, entryHeight, null);
    }

    private static void walkChildren(Entry entry, Consumer<Entry> consumer) {
        consumer.accept(entry);
        for (Entry child : entry.children) {
            OptionsList.walkChildren(child, consumer);
        }
    }

    public int method_25322() {
        return Math.min(this.field_22758, 300);
    }

    protected int method_65507() {
        return this.owner.field_22789 - 6;
    }

    public void method_44382(double scroll) {
        this.smoothScroll.target(class_3532.method_15363((float)((float)scroll), (float)0.0f, (float)this.method_44390()));
    }

    public void forceSetScrollAmount(double scroll) {
        this.smoothScroll.start((float)scroll);
        super.method_44382(scroll);
    }

    protected double method_44393() {
        return (double)this.field_62109 * (!ClientProxy.hasFastScroll && JadeUI.hasControlDown() ? 4.5 : 1.5);
    }

    public boolean method_25403(class_11909 mouseButtonEvent, double d, double e) {
        this.smoothScroll.value = this.smoothScroll.getTarget();
        super.method_44382((double)this.smoothScroll.value);
        return super.method_25403(mouseButtonEvent, d, e);
    }

    public boolean method_25370() {
        return this.owner.method_25399() == this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public class_8016 method_48205(class_8023 event) {
        Title title;
        OptionsNav.Entry navEntry = (OptionsNav.Entry)this.owner.getOptionsNav().method_25336();
        if (navEntry == null || !(event instanceof class_8023.class_8024)) return super.method_48205(event);
        class_8023.class_8024 class_80242 = (class_8023.class_8024)event;
        try {
            class_8028 class_80282;
            class_8028 direction = class_80282 = class_80242.comp_1191();
            if (direction != class_8028.field_41829) return super.method_48205(event);
            title = navEntry.getTitle();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        this.method_25395((class_364)title);
        class_8016 path = super.method_48205((class_8023)new class_8023.class_8024(class_8028.field_41827));
        this.method_25395(null);
        return path;
    }

    public void scrollToEntry(Entry entry) {
        super.method_73377((class_350.class_351)entry);
    }

    protected boolean method_73379() {
        if (PreviewOptionsScreen.isAdjustingPosition()) {
            return false;
        }
        return super.method_73379();
    }

    protected void method_57713(class_332 guiGraphics) {
        class_2960 resourceLocation2 = this.field_22740.field_1687 == null ? class_437.field_49896 : class_437.field_49898;
        guiGraphics.method_25290(class_10799.field_56883, resourceLocation2, 0, this.method_55443(), 0.0f, 0.0f, this.owner.field_22789, 2, 32, 2);
    }

    protected void renderSelection(class_332 guiGraphics, Entry entry, int i) {
        guiGraphics.method_25294(this.method_46426(), i - 2, this.method_55442(), i + entry.method_73384() + 2, 0x33FFFFFF);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        float deltaTicks = class_310.method_1551().method_61966().method_60638();
        this.smoothScroll.tick(deltaTicks);
        super.method_44382((double)Math.round(this.smoothScroll.value));
        this.field_33780 = null;
        if (!PreviewOptionsScreen.isAdjustingPosition()) {
            class_8015 lastInputType = this.field_22740.method_48186();
            mouseY = Math.min(mouseY, this.method_31383());
            if (lastInputType.method_48182() && this.method_25405(mouseX, mouseY)) {
                this.field_33780 = this.method_25308(mouseX, mouseY);
            } else if (lastInputType.method_48183() && this.method_25336() != null) {
                this.field_33780 = this.method_25336();
            }
            class_350.class_351 class_3512 = this.field_33780;
            if (class_3512 instanceof Title) {
                Title title = (Title)class_3512;
                this.setSelected(null);
                this.currentTitle = title;
            } else {
                Entry entry;
                this.setSelected((Entry)this.field_33780);
                if (this.field_33780 != null && (entry = ((Entry)this.field_33780).root()) instanceof Title) {
                    Title title;
                    this.currentTitle = title = (Title)entry;
                }
            }
        }
        this.method_49603(guiGraphics);
        this.method_25311(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.method_44380();
        this.method_57713(guiGraphics);
        this.method_44396(guiGraphics, mouseX, mouseY);
    }

    public void save() {
        this.method_25396().stream().filter(e -> e instanceof OptionValue).map(e -> (OptionValue)((Object)e)).forEach(OptionValue::save);
        if (this.diskWriter != null) {
            this.diskWriter.run();
        }
    }

    public <T extends Entry> T add(T entry) {
        this.entries.add(entry);
        if (entry instanceof Title) {
            this.setDefaultParent(entry);
        } else if (this.defaultParent != null) {
            entry.parent(this.defaultParent);
        }
        return entry;
    }

    @Nullable
    public Entry getEntryAt(double x, double y) {
        return (Entry)this.method_25308(x, y);
    }

    public int method_25337(int i) {
        return super.method_25337(i);
    }

    public int method_25319(int i) {
        return super.method_25319(i);
    }

    public void setDefaultParent(Entry defaultParent) {
        this.defaultParent = defaultParent;
    }

    public class_5250 title(String string) {
        return this.add(new Title(string)).getTitle();
    }

    public OptionValue<Float> slider(String optionName, Supplier<Float> getter, Consumer<Float> setter) {
        return this.slider(optionName, getter, setter, 0.0f, 1.0f, FloatUnaryOperator.identity());
    }

    public OptionValue<Float> slider(String optionName, Supplier<Float> getter, Consumer<Float> setter, float min, float max, FloatUnaryOperator aligner) {
        return this.add(new SliderOptionValue(optionName, getter, setter, min, max, aligner));
    }

    public <T> OptionValue<T> input(String optionName, Supplier<T> getter, Consumer<T> setter, Predicate<String> validator) {
        return this.add(new InputOptionValue<T>(this::updateSaveState, optionName, getter, setter, validator));
    }

    public <T> OptionValue<T> input(String optionName, Supplier<T> getter, Consumer<T> setter) {
        return this.input(optionName, getter, setter, (Predicate<String>)Predicates.alwaysTrue());
    }

    public OptionValue<Boolean> choices(String optionName, Supplier<Boolean> getter, BooleanConsumer setter) {
        return this.choices(optionName, getter, setter, null);
    }

    public OptionValue<Boolean> choices(String optionName, Supplier<Boolean> getter, BooleanConsumer setter, @Nullable Consumer<class_5676.class_5677<Boolean>> builderConsumer) {
        class_5676.class_5677 builder = class_5676.method_32607((class_2561)OPTION_ON, (class_2561)OPTION_OFF);
        if (builderConsumer != null) {
            builderConsumer.accept((class_5676.class_5677<Boolean>)builder);
        }
        return this.add(new CycleOptionValue<Boolean>(optionName, (class_5676.class_5677<Boolean>)builder, getter, (Consumer<Boolean>)setter));
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, Supplier<T> getter, Consumer<T> setter) {
        return this.choices(optionName, getter, setter, null);
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, Supplier<T> getter, Consumer<T> setter, @Nullable Consumer<class_5676.class_5677<T>> builderConsumer) {
        List<Enum> values = Arrays.asList((Enum[])((Enum)getter.get()).getDeclaringClass().getEnumConstants());
        class_5676.class_5677 builder = class_5676.method_32606(v -> {
            String name;
            return switch (name = v.name().toLowerCase(Locale.ENGLISH)) {
                case "on" -> OPTION_ON;
                case "off" -> OPTION_OFF;
                default -> Entry.makeTitle(optionName + "_" + name);
            };
        }).method_32620(values);
        builder.method_32618(v -> {
            String key = Entry.makeKey(optionName + "_" + v.name().toLowerCase(Locale.ENGLISH) + "_desc");
            if (!class_1074.method_4663((String)key)) {
                return null;
            }
            return class_7919.method_47407((class_2561)WailaConfigScreen.processBuiltInVariables((class_2561)class_2561.method_43471((String)key)));
        });
        if (builderConsumer != null) {
            builderConsumer.accept(builder);
        }
        return this.add(new CycleOptionValue<T>(optionName, builder, getter, setter));
    }

    public <T> OptionValue<T> choices(String optionName, Supplier<T> getter, List<T> values, Consumer<T> setter, Function<T, class_2561> nameProvider) {
        return this.add(new CycleOptionValue<T>(optionName, class_5676.method_32606(nameProvider).method_32620(values), getter, setter));
    }

    public void keybind(class_304 keybind) {
        this.add(new KeybindOptionButton(this, keybind));
    }

    public void removed() {
        this.forcePreview.clear();
        for (Entry entry : this.entries) {
            entry.parent = null;
            if (entry.children.isEmpty()) continue;
            entry.children.clear();
        }
        this.method_25339();
        this.owner = null;
    }

    public void updateSearch(String search) {
        this.method_25339();
        if (search.isBlank()) {
            this.entries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
            return;
        }
        LinkedHashSet matches = Sets.newLinkedHashSet();
        String[] keywords = search.toLowerCase(Locale.ENGLISH).split("\\s+");
        for (Entry entry : this.entries) {
            int bingo = 0;
            List<String> messages = entry.getMessages();
            block1: for (String keyword : keywords) {
                for (String message : messages) {
                    if (!message.contains(keyword)) continue;
                    ++bingo;
                    continue block1;
                }
            }
            if (bingo != keywords.length) continue;
            OptionsList.walkChildren(entry, matches::add);
            while (entry.parent() != null) {
                entry = entry.parent();
                matches.add(entry);
            }
        }
        for (Entry entry : this.entries) {
            if (!matches.contains((Object)entry)) continue;
            this.method_25321((class_350.class_351)entry);
        }
        if (matches.isEmpty()) {
            this.method_25321((class_350.class_351)new Title(class_2561.method_43471((String)"gui.jade.no_results").method_27692(class_124.field_1080)));
        }
    }

    public void updateSaveState() {
        this.invalidEntry = null;
        for (Entry entry : this.entries) {
            OptionValue value;
            if (!(entry instanceof OptionValue) || (value = (OptionValue)entry).isValidValue()) continue;
            this.invalidEntry = value;
            break;
        }
        if (this.invalidEntry == null) {
            this.owner.saveButton.method_47400(null);
        } else {
            this.owner.saveButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.jade.invalid_value_cant_save")));
        }
    }

    public void updateOptionValue(@Nullable class_2960 key) {
        for (Entry entry : this.entries) {
            if (!(entry instanceof OptionValue)) continue;
            OptionValue value = (OptionValue)entry;
            if (key != null && !key.equals((Object)value.getId())) continue;
            value.updateValue();
        }
    }

    public void showOnTop(Entry entry) {
        this.method_44382(this.field_62109 * this.method_25396().indexOf((Object)entry) + 1);
        if (entry instanceof Title) {
            Title title;
            this.currentTitle = title = (Title)entry;
        }
    }

    public void resetMappingAndUpdateButtons() {
        for (Entry entry : this.entries) {
            if (!(entry instanceof KeybindOptionButton)) continue;
            KeybindOptionButton button = (KeybindOptionButton)entry;
            button.refresh(this.selectedKey);
        }
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (this.selectedKey != null) {
            if (keyEvent.method_74231()) {
                this.selectedKey.method_1422(class_3675.field_16237);
            } else {
                this.selectedKey.method_1422(class_3675.method_15985((class_11908)keyEvent));
            }
            this.selectedKey = null;
            this.resetMappingAndUpdateButtons();
            return true;
        }
        return super.method_25404(keyEvent);
    }

    public boolean method_25402(class_11909 event, boolean bl) {
        if (this.selectedKey != null) {
            this.selectedKey.method_1422(class_3675.class_307.field_1672.method_1447(event.method_74245()));
            this.selectedKey = null;
            this.resetMappingAndUpdateButtons();
        }
        return super.method_25402(event, bl);
    }

    public void setSelected(@Nullable Entry entry) {
        this.field_22751 = entry;
        if (entry != null && this.field_22740.method_48186().method_48183()) {
            this.scrollToEntry(entry);
        }
    }

    public static class Entry
    extends class_4265.class_4266<Entry> {
        protected final class_310 client;
        protected final List<String> messages = Lists.newArrayList();
        private final List<class_339> rawWidgets = Lists.newArrayList();
        protected final List<EntryWidget> widgets = Lists.newArrayList();
        protected List<class_2561> description = List.of();
        private Entry parent;
        private List<Entry> children = List.of();

        public Entry() {
            this.client = class_310.method_1551();
        }

        public static class_5250 makeTitle(String key) {
            return class_2561.method_43471((String)Entry.makeKey(key));
        }

        public static String makeKey(String key) {
            return class_156.method_646((String)"config", (class_2960)class_2960.method_60655((String)"jade", (String)key));
        }

        public class_339 getFirstWidget() {
            return this.rawWidgets.isEmpty() ? null : this.rawWidgets.getFirst();
        }

        public void addWidget(class_339 widget, int offsetX) {
            this.addWidget(new EntryWidget(widget, offsetX, -widget.method_25364() / 2, true));
        }

        public void addWidget(EntryWidget widget) {
            this.widgets.add(widget);
            this.rawWidgets.add(widget.widget());
        }

        public List<? extends class_339> method_25396() {
            return this.rawWidgets;
        }

        public List<? extends class_6379> method_37025() {
            return this.method_25396();
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            for (EntryWidget widget : this.widgets) {
                class_339 rawWidget = widget.widget();
                int x = widget.floatRight() ? this.method_73387() - 110 + widget.offsetX() : 10 + widget.offsetX();
                rawWidget.method_46421(this.method_73380() + x);
                rawWidget.method_46419(this.method_73382() + this.method_73384() / 2 + widget.offsetY());
                rawWidget.method_25394(guiGraphics, mouseX, mouseY, deltaTime);
            }
        }

        public void setDisabled(boolean disabled) {
            for (class_339 widget : this.rawWidgets) {
                boolean bl = widget.field_22763 = !disabled;
                if (!(widget instanceof class_342)) continue;
                class_342 editBox = (class_342)widget;
                editBox.method_1888(!disabled);
            }
        }

        public List<class_2561> getDescription() {
            return this.description;
        }

        public List<class_2561> getDescriptionOnShift() {
            return List.of();
        }

        public int getTextX() {
            return 0;
        }

        public int getTextWidth() {
            return 0;
        }

        public Entry parent(Entry parent) {
            this.parent = parent;
            if (parent.children.isEmpty()) {
                parent.children = Lists.newArrayList();
            }
            parent.children.add(this);
            return this;
        }

        public Entry parent() {
            return this.parent;
        }

        public Entry root() {
            Entry entry = this;
            while (entry.parent() != null) {
                entry = entry.parent();
            }
            return entry;
        }

        public final List<String> getMessages() {
            return this.messages;
        }

        public void addMessage(String message) {
            this.messages.add(class_3544.method_15440((String)message).toLowerCase(Locale.ENGLISH));
        }

        public void addMessageKey(String key) {
            if (class_1074.method_4663((String)(key = Entry.makeKey(key + "_extra_msg")))) {
                this.addMessage(class_1074.method_4662((String)key, (Object[])new Object[0]));
            }
        }
    }

    public static class Title
    extends Entry {
        public class_2561 narration;
        private final class_5250 title;

        public Title(String key) {
            this.title = Title.makeTitle(key);
            this.addMessageKey(key);
            this.addMessage(this.title.getString());
            key = Title.makeKey(key + "_desc");
            if (class_1074.method_4663((String)key)) {
                this.description = List.of(class_2561.method_43471((String)key));
                this.addMessage(((class_2561)this.description.getFirst()).getString());
            }
            this.narration = class_2561.method_43469((String)"narration.jade.category", (Object[])new Object[]{this.title});
        }

        public Title(class_5250 title) {
            this.title = title;
            this.narration = title;
        }

        public class_5250 getTitle() {
            return this.title;
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            class_327 class_3272 = this.client.field_1772;
            int n = this.getTextX();
            int n2 = this.method_73382() + this.method_73384();
            Objects.requireNonNull(this.client.field_1772);
            guiGraphics.method_27535(class_3272, (class_2561)this.title, n, n2 - 9, -1);
        }

        @Override
        public int getTextX() {
            return this.method_73388() - this.getTextWidth() / 2;
        }

        @Override
        public int getTextWidth() {
            return this.client.field_1772.method_27525((class_5348)this.title);
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return List.of(new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 narrationElementOutput) {
                    narrationElementOutput.method_37034(class_6381.field_33788, narration);
                }
            });
        }
    }

    public record EntryWidget(class_339 widget, int offsetX, int offsetY, boolean floatRight) {
    }
}

