/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.event;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.api.event.v1.entity.living.AnimalTameCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLivingEvents;
import fuzs.puzzleslib.fabric.impl.event.CapturedDropsEntity;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.event.data.DefaultedFloat;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.fabric.impl.resource.v1.ResourceLoaderImpl;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

public final class FabricEventImplHelper {
    private FabricEventImplHelper() {
    }

    public static int onAnimalTame(class_1429 animal, class_1657 player, int intValue) {
        return FabricEventImplHelper.onAnimalTame(animal, player, intValue, 1, intValue == 0);
    }

    public static int onAnimalTame(class_1429 animal, class_1657 player, int intValue, int returnValue, boolean tameCondition) {
        if (tameCondition && ((AnimalTameCallback)FabricLivingEvents.ANIMAL_TAME.invoker()).onAnimalTame(animal, player).isInterrupt()) {
            return returnValue;
        }
        return intValue;
    }

    public static float onLivingHurt(class_1309 livingEntity, class_3218 serverLevel, class_1282 damageSource, float damageAmount, MutableBoolean cancelInjection) {
        if (!livingEntity.method_5679(serverLevel, damageSource)) {
            DefaultedFloat damageAmountValue = DefaultedFloat.fromValue(damageAmount);
            EventResult eventResult = ((LivingHurtCallback)FabricLivingEvents.LIVING_HURT.invoker()).onLivingHurt(livingEntity, damageSource, damageAmountValue);
            if (eventResult.isInterrupt()) {
                cancelInjection.setTrue();
            }
            return damageAmountValue.getAsOptionalFloat().orElse(Float.valueOf(damageAmount)).floatValue();
        }
        return damageAmount;
    }

    public static boolean tryOnLivingDrops(class_1309 entity, class_1282 damageSource, int lastHurtByPlayerMemoryTime) {
        Collection<class_1542> capturedDrops = ((CapturedDropsEntity)entity).puzzleslib$acceptCapturedDrops(null);
        if (capturedDrops != null) {
            EventResult eventResult = ((LivingDropsCallback)FabricLivingEvents.LIVING_DROPS.invoker()).onLivingDrops(entity, damageSource, capturedDrops, lastHurtByPlayerMemoryTime > 0);
            if (eventResult.isPass()) {
                capturedDrops.forEach(itemEntity -> entity.method_73183().method_8649((class_1297)itemEntity));
            }
            return true;
        }
        return false;
    }

    public static EventResult onPlaySound(LevelSoundEventInvoker eventInvoker, Args args, MutableValue<class_6880<class_3414>> soundEvent, int soundSourceOrdinal, int soundVolumeOrdinal, int soundPitchOrdinal) {
        Preconditions.checkArgument((boolean)(args.get(soundSourceOrdinal) instanceof class_3419), (Object)"sound source is wrong type");
        Preconditions.checkArgument((boolean)(args.get(soundVolumeOrdinal) instanceof Float), (Object)"sound volume is wrong type");
        Preconditions.checkArgument((boolean)(args.get(soundPitchOrdinal) instanceof Float), (Object)"sound pitch is wrong type");
        MutableValue<class_3419> soundSource = MutableValue.fromEvent(soundSourceX -> args.set(soundSourceOrdinal, soundSourceX), () -> (class_3419)args.get(soundSourceOrdinal));
        MutableFloat soundVolume = MutableFloat.fromEvent(volume -> args.set(soundVolumeOrdinal, volume), () -> (Float)args.get(soundVolumeOrdinal));
        MutableFloat soundPitch = MutableFloat.fromEvent(pitch -> args.set(soundPitchOrdinal, pitch), () -> (Float)args.get(soundPitchOrdinal));
        return eventInvoker.onPlaySound(soundEvent, soundSource, soundVolume, soundPitch);
    }

    public static BiConsumer<class_2960, class_3302> getReloadListenerConsumer(MutableObject<List<class_3302>> mutableObject) {
        return FabricEventImplHelper.getRegisteredReloadListeners(class_3264.field_14190).map(registeredReloadListeners -> registeredReloadListeners::put).orElse((resourceLocation, reloadListener) -> {
            if (!(mutableObject.getValue() instanceof ArrayList)) {
                mutableObject.setValue(new ArrayList((Collection)mutableObject.getValue()));
            }
            ((List)mutableObject.getValue()).add(reloadListener);
        });
    }

    private static Optional<Map<class_2960, class_3302>> getRegisteredReloadListeners(class_3264 packType) {
        try {
            Field field = ResourceLoaderImpl.class.getDeclaredField("addedReloaders");
            field.setAccessible(true);
            Object o = MethodHandles.lookup().unreflectGetter(field).invoke(ResourceLoader.get((class_3264)packType));
            return Optional.of((Map)o);
        }
        catch (Throwable throwable) {
            PuzzlesLib.LOGGER.warn("Unable to access Fabric registered reload listeners: {}", (Object)throwable.getMessage());
            return Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface LevelSoundEventInvoker {
        public EventResult onPlaySound(MutableValue<class_6880<class_3414>> var1, MutableValue<class_3419> var2, MutableFloat var3, MutableFloat var4);
    }
}

